% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichmapColorFunctions.R
\name{enrichmapColorFunctions}
\alias{enrichmapColorFunctions}
\alias{gseaColorFun}
\alias{cameraColorFun}
\title{Color Functions for enrichmap}
\usage{
gseaColorFun(statistics, colors = c("#3366ff", "darkred"))

cameraColorFun(statistics, colors = c("#3366ff", "darkred"))
}
\arguments{
\item{statistics}{numeric matrix or vector of statistics. Missing values are
removed. Used to compute limits for the color legend.}

\item{colors}{vector of 2 colors for the most negative and most positive
values of \code{statistics}. Default is "#3366ff" (blue) and "darkred".}
}
\value{
a named list of breaks and colors for the heatmap legend.
}
\description{
Heatmap color functions for plotting GSEA-like and CAMERA-like
results with \code{\link{enrichmap}}.
}
\details{
For \code{gseaColorFun}, the \code{statistics} are expected to be
normalized enrichment scores (NES). Due to how the NES is formulated,
values between -1 and 1 are never significant or otherwise interesting, so
they are given a white fill so as to not appear in the heatmap (see
examples).
}
\examples{
set.seed(0)
x <- rnorm(10, mean = 0, sd = 2)

cameraColorFun(x)
cameraColorFun(x[x >= 0]) # positive only

gseaColorFun(x)
gseaColorFun(x[x >= 0]) # positive only
}
\seealso{
\code{\link{extendRangeNum}}
}
