% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fimo_granges.R
\name{fimo_granges}
\alias{fimo_granges}
\title{create a list of GRanges for FIMO hits in a GenomicFiles instance, corresponding to a GRanges-based query}
\usage{
fimo_granges(gf, query)
}
\arguments{
\item{gf}{GenomicFiles instance, like fimo16 in TFutils}

\item{query}{a GRanges specifying ranges to check for TF binding scores}
}
\value{
a list of GRanges, produced by GenomicFiles::reduceByRange
}
\description{
create a list of GRanges for FIMO hits in a GenomicFiles instance, corresponding to a GRanges-based query
}
\note{
Be sure to use \verb{register([BPPARAM])} appropriately.
}
\examples{
if (interactive()) {   # need internet
 # setup -- annotate fimo16 object and create an informative
 # query
 colnames(fimo16) = fimo16$HGNC
 si = Seqinfo::Seqinfo(genome="hg19")["chr17"] # to fix query genome
 myg = GRanges("chr17", IRanges(38.07e6,38.09e6), seqinfo=si)
 requireNamespace("BiocParallel")
 BiocParallel::register(BiocParallel::SerialParam())
 f1 = fimo_granges(fimo16[, c("VDR", "POU2F1")], myg)
 f1
}
}
