% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-functions.R
\name{metaanalysis_fx}
\alias{metaanalysis_fx}
\title{Perform Meta-analysis for each TF}
\usage{
metaanalysis_fx(dat)
}
\arguments{
\item{dat}{A data frame with columns: TF, OR, OR.SE, Accession, adj.pval.}
}
\value{
A list with:
  - summary: a data frame of ranked meta-analysis results per TF
  - results: a named list of raw meta-analysis objects from the 
   `meta` package
}
\description{
Conducts a random-effects meta-analysis of odds ratios (OR) 
and standard errors (OR.SE) for each TF using the `meta` package.
}
\examples{
df <- data.frame(TF = c('A', 'A', 'A', 'B', 'B'),
                 OR = c(1, 1.2, 1.23, 4, 4.5),
                 OR.SE = c(1e-5, 5e-4, 2e-4, 1e-3, 1e-2),
                 Accession = c('Chip1', 'Chip2', 'Chip3', 'Chip4', 'Chip5'),
                 adj.pval = c(1e-5, 5e-4, 2e-4, 1e-3, 1e-2))
res <- metaanalysis_fx(df)
}
