% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-functions.R
\name{Select_genes}
\alias{Select_genes}
\title{Extracts genes according to logFoldChange and p-val limits}
\usage{
Select_genes(
  GeneExpression_df,
  max_pval = 0.05,
  min_pval = 0,
  max_LFC = Inf,
  min_LFC = -Inf
)
}
\arguments{
\item{GeneExpression_df}{A data frame with the following fields:
'Gene', 'pvalue' or 'pval.adj', 'log2FoldChange'.}

\item{max_pval}{maximum p-value allowed, 0.05 by default.}

\item{min_pval}{minimum p-value allowed, 0 by default.}

\item{max_LFC}{maximum log2(FoldChange) allowed.}

\item{min_LFC}{minimum log2(FoldChange) allowed.}
}
\value{
A character vector of gene IDs.
}
\description{
Function to extract Gene IDs from a dataframe according
to the established limits for log2(FoldChange) and p-value.
If possible, the function will use the adjusted p-value column.
}
\examples{
data('hypoxia', package='TFEA.ChIP')
Select_genes(hypoxia)
}
