% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxH5-class.R
\docType{class}
\name{TENxH5-class}
\alias{TENxH5-class}
\alias{.TENxH5}
\alias{rowData,TENxH5-method}
\alias{dim,TENxH5-method}
\alias{dimnames,TENxH5-method}
\alias{genome,TENxH5-method}
\alias{rowRanges,TENxH5-method}
\alias{import,TENxH5,ANY,ANY-method}
\alias{show,TENxH5-method}
\title{TENxH5: The HDF5 file representation class for 10X Data}
\usage{
\S4method{rowData}{TENxH5}(x, use.names = TRUE, ...)

\S4method{dim}{TENxH5}(x)

\S4method{dimnames}{TENxH5}(x)

\S4method{genome}{TENxH5}(x)

\S4method{rowRanges}{TENxH5}(x, ...)

\S4method{import}{TENxH5,ANY,ANY}(con, format, text, ...)

\S4method{show}{TENxH5}(object)
}
\arguments{
\item{x}{A \code{TENxH5} object}

\item{use.names}{
    For \code{rowData}: Like \code{\link[S4Vectors]{mcols}(x)}, by default
    \code{rowData(x)} propagates the rownames of \code{x} to the returned
    \link[S4Vectors]{DataFrame} object (note that for a SummarizedExperiment
    object or derivative, the rownames are also the names i.e.
    \code{rownames(x)} is always the same as \code{names(x)}).
    Setting \code{use.names=FALSE} suppresses this propagation i.e. it
    returns a \link[S4Vectors]{DataFrame} object with no rownames. Use this
    when \code{rowData(x)} fails, which can happen when the rownames contain
    NAs (because the rownames of a SummarizedExperiment object or derivative
    can contain NAs, but the rownames of a \link[S4Vectors]{DataFrame} object
    cannot).

    For \code{combineRows} and \code{combineCols}: See Combining section
    below.
  }

\item{...}{
    For \code{assay}, arguments in \code{...} are forwarded to \code{assays}.

    For \code{rbind}, \code{cbind}, \code{...} contains SummarizedExperiment
    objects (or derivatives) to be combined.

    For other accessors, ignored.
  }

\item{con}{The connection from which data is loaded or to which data is
saved. If this is a \code{character} vector, it is assumed to be a file name and
a corresponding file connection is created and then closed after exporting
the object. If it is a \link[BiocIO:BiocFile-class]{BiocFile} derivative, the
data is loaded from or saved to the underlying resource. If missing, the
function will return the output as a character vector, rather than writing
to a connection.}

\item{format}{The format of the output. If missing and \code{con} is a
file name, the format is derived from the file extension. This argument is
unnecessary when \code{con} is a derivative of \link[BiocIO:BiocFile-class]{BiocFile}.}

\item{text}{If \code{con} is missing, this can be a character vector directly
providing the string data to import.}

\item{object}{A \code{TENxH5} class object}
}
\value{
A \code{TENxH5} class object
}
\description{
This class is designed to work with 10x Single Cell datasets.
It was developed using the PBMC 3k 10X dataset from the CellRanger v2
pipeline.
}
\details{
The data version "3" mainly includes a "matrix" group and "interval"
information within the file. Version "2" data does not include
ranged-based information and has a different directory structure compared
to version "3". See the internal \code{data.frame}: \code{TENxIO:::h5.version.map} for
a map of fields and their corresponding file locations within the H5 file.
This map is used to create the \code{rowData} structure from the file.
}
\section{Methods (by generic)}{
\itemize{
\item \code{rowData(TENxH5)}: Generate the rowData ad hoc from a TENxH5 file

\item \code{dim(TENxH5)}: Get the dimensions of the data as stored in the file

\item \code{dimnames(TENxH5)}: Get the dimension names from the file

\item \code{genome(TENxH5)}: Read genome string from file

\item \code{rowRanges(TENxH5)}: Read interval data and represent as GRanges

\item \code{import(con = TENxH5, format = ANY, text = ANY)}: Import TENxH5 data as a SingleCellExperiment; see section
below

\item \code{show(TENxH5)}: Display a snapshot of the contents within a TENxH5 file
before import

}}
\section{Slots}{

\describe{
\item{\code{version}}{character(1) There are currently two recognized versions
associated with 10X data, either version "2" or "3". See details for more
information.}

\item{\code{group}}{character(1) The HDF5 group embedded within the file structure,
this is usually either the "matrix" or "outs" group but other groups are
supported as well.}

\item{\code{ranges}}{character(1) The HDF5 internal folder location embedded within
the file that points to the ranged data information, e.g.,
"/features/interval".}
}}

\section{import}{

The \code{import} method uses \code{DelayedArray::TENxMatrix} to represent matrix
data. Generally, version 3 datasets contain associated genomic coordinates.
The associated feature data, as displayed by the \code{rowData} method, is
queried for the "Type" column which will indicate that a \code{splitAltExps}
operation is appropriate. If a \code{ref} input is provided to the constructor
function \code{TENxH5}, it will be used as the main experiment; otherwise, the
most frequent category in the "Type" column will be used. For example,
the Multiome ATAC + Gene Expression feature data contains both 'Gene
Expression' and 'Peaks' labels in the "Type" column.
}

\seealso{
\link{TENxH5}
}
