% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrepareSummarizedExperimentTensorSquare.R
\name{PrepareSummarizedExperimentTensorSquare}
\alias{PrepareSummarizedExperimentTensorSquare}
\title{Title
Generate feature values formatted as a tensor format from Squared matrix}
\usage{
PrepareSummarizedExperimentTensorSquare(
  sample = list(NULL),
  feature,
  value,
  featureRange = GRanges(NULL),
  sampleData = list(NULL)
)
}
\arguments{
\item{sample}{Sample names}

\item{feature}{Feature id names}

\item{value}{Squared Feature values}

\item{featureRange}{Genomic coordinate attributed to feature id (if any)}

\item{sampleData}{Sample property (labels etc)}
}
\value{
A tensor including sample names, feature values,
associated with featureRange and sample properties
}
\description{
Title
Generate feature values formatted as a tensor format from Squared matrix
}
\examples{
omics1 <- matrix(runif(100),10)
dimnames(omics1) <- list(seq_len(10),seq_len(10))
omics2 <- matrix(runif(100),10)
dimnames(omics2) <- dimnames(omics1)
Multi <- list(omics1,omics2)
Z <- PrepareSummarizedExperimentTensorSquare(
   sample=matrix(colnames(omics1),1),
   feature=list(omics1=rownames(omics1),
   omics2=rownames(omics2)),
   value=convertSquare(Multi),
   sampleData=list(NA))
}
