% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{tableAUC}
\alias{tableAUC}
\title{Create a table of results for t-tests and bootstrapped AUCs for multiple scored signatures.}
\usage{
tableAUC(
  SE_scored,
  annotationColName,
  signatureColNames,
  num.boot = 100,
  pb.show = TRUE,
  output = "DataTable"
)
}
\arguments{
\item{SE_scored}{a \code{SummarizedExperiment} object with genes as the
row features and signature scores in the \code{colData}. There should also
be a column of annotation data. Required.}

\item{annotationColName}{a character string giving the column name in
\code{colData} that contains the annotation data. Required.}

\item{signatureColNames}{a vector of column names in the
\code{colData} that contain the signature score data. Required.}

\item{num.boot}{integer. The number of times to bootstrap the data. The
default is \code{100}.}

\item{pb.show}{logical for whether to show a progress bar while running code.
The default is \code{TRUE}.}

\item{output}{a character string indicating the table output format. Possible
values are \code{DataTable} and \code{data.frame}. The default is
\code{DataTable}.}
}
\value{
A JavaScript table with an R interface using the \code{DT} package.
}
\description{
This function collects the results of bootstrapping and t-tests for a scored
gene expression dataset and presents them using a JavaScript table with an
R interface, or as a \code{data.frame}.
}
\examples{
# Run signature profiling
 choose_sigs <- TBsignatures[c(1, 2)]
 prof_indian <- runTBsigProfiler(TB_indian, useAssay = "logcounts",
                                 algorithm = "ssGSEA",
                                 signatures = choose_sigs,
                                 parallel.sz = 1,
                                 update_genes = FALSE)
 # Create table
 tableAUC(SE_scored = prof_indian, annotationColName = "label",
          signatureColNames = names(choose_sigs))

 # Create data.frame object
h <-  tableAUC(SE_scored = prof_indian, annotationColName = "label",
               signatureColNames = names(choose_sigs),
               output = "data.frame",
               num.boot = 5)
head(h)

}
