% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{signatureROCplot_CI}
\alias{signatureROCplot_CI}
\title{Create an array of ROC plots with confidence interval bands to compare signatures.}
\usage{
signatureROCplot_CI(
  inputData,
  annotationData,
  signatureColNames,
  annotationColName,
  scale = FALSE,
  choose_colors = c("cornflowerblue", "gray50", "gray79"),
  name = NULL,
  nrow = NULL,
  ncol = NULL,
  ci.lev = 0.95,
  pb.show = TRUE
)
}
\arguments{
\item{inputData}{an input data object. It should either be of the class
\code{SummarizedExperiment} and contain the profiled signature data and
annotation data as columns in the \code{colData}, or alternatively be of the
classes \code{data.frame} or \code{matrix} and contain only the gene
expression data. Required.}

\item{annotationData}{a \code{data.frame} or \code{matrix} of annotation data,
with one column. Only required if \code{inputData} is a \code{data.frame} or
\code{matrix} of signature data.}

\item{signatureColNames}{a \code{vector} of the column names of \code{inputData}
that contain the signature data. If \code{inputData} is a
\code{SummarizedExperiment} object, these are the column names of the
object \code{colData}.}

\item{annotationColName}{a character string naming the column name in the
\code{colData} that contains the annotation data to be used in making the
boxplot. Only required if inputData is a \code{SummarizedExperiment} object.}

\item{scale}{logical. Setting \code{scale = TRUE} scales the signature data.
The default is \code{FALSE}.}

\item{choose_colors}{a vector of length 3 defining the colors to be used
in the ROC plots. The default is \code{c("cornflowerblue",
"gray50", "gray79")}.}

\item{name}{a character string giving the title of the ROC plot. If
\code{NULL}, the plot title will be
\code{"ROC Plots for Gene Signatures, <ci.lev>\% Confidence"}.
The default is \code{NULL}.}

\item{nrow}{integer giving the number of rows in the resulting array.}

\item{ncol}{integer giving the number of columns in the resulting array.}

\item{ci.lev}{a number between 0 and 1 giving the desired level of
confidence for computing ROC curve estimations.}

\item{pb.show}{logical for whether to show a progress bar while running code.
The default is \code{TRUE}.}
}
\value{
An array of ROC plots.
}
\description{
Create an array of ROC plots with confidence interval bands to compare signatures.
}
\examples{
# Run signature profiling

 choose_sigs <- TBsignatures[c(1, 2)]
 prof_indian <- runTBsigProfiler(TB_indian, useAssay = "logcounts",
                                 algorithm = "Zscore",
                                 signatures = choose_sigs,
                                 parallel.sz = 1)

# Create ROC plots with confidence intervals
signatureROCplot_CI(prof_indian, signatureColNames = names(choose_sigs),
                    annotationColName = "label")

}
