% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{compareBoxplots}
\alias{compareBoxplots}
\title{Create a comparison plot of boxplots for bootstrapped AUC values.}
\usage{
compareBoxplots(
  SE_scored,
  annotationColName,
  signatureColNames,
  num.boot = 100,
  name = "Boxplot Comparison of Signature AUCs",
  pb.show = TRUE,
  abline.col = "red",
  fill.col = "gray79",
  outline.col = "black",
  rotateLabels = FALSE,
  violinPlot = FALSE
)
}
\arguments{
\item{SE_scored}{a \code{SummarizedExperiment} object with genes as the
row features and signature scores in the \code{colData}. There should also
be a column of annotation data. Required.}

\item{annotationColName}{a character string giving the column name in
\code{colData} that contains the annotation data. Required.}

\item{signatureColNames}{a vector of column names in the
\code{colData} that contain the signature score data. Required.}

\item{num.boot}{an integer indicating the number of times to bootstrap the
data.}

\item{name}{a character string giving the overall title for the plot.
The default is \code{"Boxplot Comparison of Signature AUCs"}.}

\item{pb.show}{logical for whether to show a progress bar while running code.
Default is \code{TRUE}.}

\item{abline.col}{the color to be used for the dotted line at AUC = 0.5
(the chance line). The default is \code{"red"}.}

\item{fill.col}{the color to be used to fill the boxplots.
The default is \code{"white"}.}

\item{outline.col}{the color to be used for the boxplot outlines.
The default is \code{"black"}.}

\item{rotateLabels}{If \code{TRUE}, rotate labels. Default is \code{FALSE}.}

\item{violinPlot}{logical. Setting \code{violinPlot = TRUE} creates violin
plots in place of boxplots. The mean and +/- 1 standard deviation are added
to the violin plot interior for each signature.
The default is \code{FALSE}.}
}
\value{
A plot with side-by-side boxplots of bootstrapped AUC values for
each specified signature.
}
\description{
Present the results of AUC bootstrapping for a collection of scored
signatures via boxplots.
}
\examples{
# Run signature profiling
 choose_sigs <- TBsignatures[c("Zak_RISK_16", "Zhao_NANO_6")]
 prof_indian <- runTBsigProfiler(TB_indian[seq_len(25), ],
                                 useAssay = "logcounts",
                                 algorithm = "ssGSEA",
                                 signatures = choose_sigs,
                                 parallel.sz = 1)
 # Create boxplots
 compareBoxplots(prof_indian, annotationColName = "label",
                 signatureColNames = names(choose_sigs), rotateLabels = TRUE)

}
