% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{compareAlgs}
\alias{compareAlgs}
\title{Compare scoring algorithms on a single signature via heatmap or boxplot.}
\usage{
compareAlgs(
  input,
  signatures = NULL,
  annotationColName,
  useAssay = "counts",
  algorithm = c("GSVA", "ssGSEA", "ASSIGN", "PLAGE", "Zscore", "singscore"),
  showColumnNames = TRUE,
  showRowNames = TRUE,
  scale = FALSE,
  colorSets = c("Set1", "Set2", "Set3", "Pastel1", "Pastel2", "Accent", "Dark2",
    "Paired"),
  choose_color = c("blue", "gray95", "red"),
  colList = list(),
  show.pb = FALSE,
  parallel.sz = 0,
  output = "heatmap",
  num.boot = 100,
  column_order = NULL
)
}
\arguments{
\item{input}{an input data object of the class \code{"SummarizedExperiment"}.
Required.}

\item{signatures}{a \code{list} of signatures to run with their associated genes.
This list should be in the same format as \code{TBsignatures}, included in
the TBSignatureProfiler package. If \code{signatures = NULL}, the default set
of signatures \code{TBsignatures} list is used.
For details, run \code{?TBsignatures}.
If <2 genes in a signature are present in the sample, that signature will
not be evaluated and will not be present in the resulting SE object.
The default is \code{NULL}.}

\item{annotationColName}{a character string giving the column name in
\code{colData} that contains the annotation data. Required.}

\item{useAssay}{a character string specifying the assay to use for signature
profiling when \code{input} is a \code{SummarizedExperiment}. Required only for
input data of the class \code{SummarizedExperiment}. If null, the assay
used will be \code{"counts"}. The default is \code{NULL.}}

\item{algorithm}{a vector of algorithms to run, or character string if only
one is desired. The default is \code{c("GSVA", "ssGSEA", "ASSIGN",
"PLAGE", "Zscore", "singscore")}. NOTE: ASSIGN takes a long time to run and
is not recommended for efficient use.}

\item{showColumnNames}{logical. Setting \code{showColumnNames = TRUE} will
show the column names (i.e. sample names) on the heatmap. The default is
\code{TRUE}.}

\item{showRowNames}{logical. Setting \code{showColumnNames = TRUE} will
show the row names (i.e. signature names) on the heatmap. The default is
\code{TRUE}.}

\item{scale}{logical. Setting \code{scale = TRUE} scales the signature data.
The default is \code{FALSE}.}

\item{colorSets}{a vector of names listing the color sets in the order
that they should be used in creating the heatmap. By default, this function
will use the color sets in the order listed in \code{Usage} for annotation
information. You may replace the default with the same collection of sets
in order that you want to use them, or provide custom color sets with the
\code{colList} parameter.}

\item{choose_color}{a vector of color names to be interpolated for the
heatmap gradient, or a \code{colorRamp} function produced by
\code{circlize::colorRamp2}. The default is \code{c("blue", "gray95", "red")}.}

\item{colList}{a named \code{list} of named vectors specifying custom color
information to
pass to \code{ComplexHeatmap::Heatmap()}. The list should have as many
elements as there are annotation columns, and each element name should
correspond exactly with the name of each annotation column.
The colors in the vector elements should be named according to the
levels of the factor in that column's annotation data if the annotation
is discrete, or it should be produced with \code{circlize::colorRamp2}
if the annotation is continuous.
By default, \code{ColorBrewer} color sets will be used.
See the the parameter \code{colorSets} for additional details.}

\item{show.pb}{logical, whether warnings and other output
from the profiling should be suppressed (including progress bar output).
Default is \code{FALSE}.}

\item{parallel.sz}{an integer identifying the number of processors to use
when running the calculations in parallel for the GSVA and ssGSEA algorithms.
If \code{parallel.sz = 0}, all cores are used. The default is \code{0}.}

\item{output}{a character string specifying whether the outputted plot
should be a \code{"heatmap"} or \code{"boxplot"}. The default is
\code{"heatmap"}.}

\item{num.boot}{an integer indicating the number of times to bootstrap the
data.}

\item{column_order}{a vector of character strings indicating the order in
which to manually arrange the heatmap columns. Default is \code{NULL},
such that column order is automatically determined via clustering.}
}
\value{
A heatmap or boxplot for each signature specified comparing
the enumerated algorithms.
}
\description{
It may be useful to compare the results of scoring across several different
scoring algorithms via a method of visualization, such as a heatmap. The
\code{compareSigs} function allows the input of a SummarizedExperiment
data object and conducts
profiling on each signature desired, and outputting a heatmap or boxplot
for each signature.
}
\examples{
compareAlgs(TB_indian,
            signatures = TBsignatures[c("Gliddon_OD_3")],
            annotationColName = "label",
            algorithm = c("ssGSEA", "PLAGE"),
            scale = TRUE, parallel.sz = 1, output = "heatmap")

}
