% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{TBcommon}
\alias{TBcommon}
\title{A list of published TB signatures, using author-given names.}
\format{
list
}
\source{
\itemize{
\item \strong{Anderson_42}: Anderson, Suzanne T., Myrsini Kaforou, Andrew J. Brent, Victoria J. Wright, Claire M. Banwell, George Chagaluka, Amelia C. Crampin, et al. 2014. "Diagnosis of Childhood Tuberculosis and Host RNA Expression in Africa." The New England Journal of Medicine 370 (18): 1712-23. \url{https://dx.doi.org/10.1056/NEJMoa130365710.1056/NEJMoa1303657}
\item \strong{Anderson_OD_51}: Anderson, Suzanne T., Myrsini Kaforou, Andrew J. Brent, Victoria J. Wright, Claire M. Banwell, George Chagaluka, Amelia C. Crampin, et al. 2014. "Diagnosis of Childhood Tuberculosis and Host RNA Expression in Africa." The New England Journal of Medicine 370 (18): 1712-23. \url{https://dx.doi.org/10.1056/NEJMoa130365710.1056/NEJMoa1303657}
\item \strong{Berry_393}: Berry, Matthew P. R., Christine M. Graham, Finlay W. McNab, Zhaohui Xu, Susannah A. A. Bloch, Tolu Oni, Katalin A. Wilkinson, et al. 2010. "An Interferon-Inducible Neutrophil-Driven Blood Transcriptional Signature in Human Tuberculosis." Nature 466 (7309): 973-77. \url{https://dx.doi.org/10.1038/nature0924710.1038/nature09247}
\item \strong{Berry_OD_86}: Berry, Matthew P. R., Christine M. Graham, Finlay W. McNab, Zhaohui Xu, Susannah A. A. Bloch, Tolu Oni, Katalin A. Wilkinson, et al. 2010. "An Interferon-Inducible Neutrophil-Driven Blood Transcriptional Signature in Human Tuberculosis." Nature 466 (7309): 973-77. \url{https://dx.doi.org/10.1038/nature0924710.1038/nature09247}
\item \strong{Blankley_380}: Blankley, Simon, Christine M. Graham, Joe Levin, Jacob Turner, Matthew P. R. Berry, Chloe I. Bloom, Zhaohui Xu, et al. 2016. "A 380-Gene Meta-Signature of Active Tuberculosis Compared with Healthy Controls." The European Respiratory Journal: Official Journal of the European Society for Clinical Respiratory Physiology 47 (6): 1873-76. \url{https://dx.doi.org/10.1183/13993003.02121-201510.1183/13993003.02121-2015}
\item \strong{Blankley_5}: Blankley, Simon, Christine M. Graham, Joe Levin, Jacob Turner, Matthew P. R. Berry, Chloe I. Bloom, Zhaohui Xu, et al. 2016. "A 380-Gene Meta-Signature of Active Tuberculosis Compared with Healthy Controls." The European Respiratory Journal: Official Journal of the European Society for Clinical Respiratory Physiology 47 (6): 1873-76. \url{https://dx.doi.org/10.1183/13993003.02121-201510.1183/13993003.02121-2015}
\item \strong{Bloom_OD_144}: Bloom, Chloe I., Christine M. Graham, Matthew P. R. Berry, Fotini Rozakeas, Paul S. Redford, Yuanyuan Wang, Zhaohui Xu, et al. 2013. "Transcriptional Blood Signatures Distinguish Pulmonary Tuberculosis, Pulmonary Sarcoidosis, Pneumonias and Lung Cancers." PloS One 8 (8): e70630. \url{https://dx.doi.org/10.1371/journal.pone.007063010.1371/journal.pone.0070630}
\item \strong{Bloom_RES_268}: Bloom CI, Graham CM, Berry MP, et al. Detectable changes in the blood transcriptome are present after two weeks of antituberculosis therapy. PLoS One. 2012;7(10):e46191. \url{https://dx.doi.org/10.3389/fmicb.2021.65056710.3389/fmicb.2021.650567}
\item \strong{Bloom_RES_558}: Bloom CI, Graham CM, Berry MP, et al. Detectable changes in the blood transcriptome are present after two weeks of antituberculosis therapy. PLoS One. 2012;7(10):e46191. \url{https://dx.doi.org/10.3389/fmicb.2021.65056710.3389/fmicb.2021.650567}
\item \strong{Chen_5}: Chen L, Hua J, He X. Coexpression Network Analysis-Based Identification of Critical Genes Differentiating between Latent and Active Tuberculosis. Dis Markers. 2022;2022:2090560. \url{http://dx.doi.org/10.1155/2022/209056010.1155/2022/2090560}
\item \strong{Chen_HIV_4}: Chen Y, Wang Q, Lin S, et al. Meta-Analysis of Peripheral Blood Transcriptome Datasets Reveals a Biomarker Panel for Tuberculosis in Patients Infected With HIV. Front Cell Infect Microbiol. 2021;11:585919. Published 2021 Mar 19. \url{https://dx.doi.org/10.3389/fcimb.2021.58591910.3389/fcimb.2021.585919}
\item \strong{Chendi_HIV_2}: Chendi BH, Tveiten H, Snyders CI, et al. CCL1 and IL-2Ra differentiate Tuberculosis disease from latent infection Irrespective of HIV infection in low TB burden countries. J Infect. 2021;S0163-4453(21)00379-0. \url{https://dx.doi.org/10.1016/j.jinf.2021.07.03610.1016/j.jinf.2021.07.036}
\item \strong{RISK11}: Darboe, F. et al. Diagnostic performance of an optimized transcriptomic signature of risk of tuberculosis in cryopreserved peripheral blood mononuclear cells. Tuberculosis 108, 124-126 (2018). \url{https://dx.doi.org/ 10.1016/j.tube.2017.11.001 10.1016/j.tube.2017.11.001}
\item \strong{Dawany_HIV_251}: Dawany, N. et al. Identification of a 251 gene expression signature that can accurately detect M. tuberculosis in patients with and without HIV co-infection. PLoS One 9, (2014). \url{https://dx.doi.org/10.1371/journal.pone.008992510.1371/journal.pone.0089925}
\item \strong{CMTB_CT}: Duffy FJ, Olson GS, Gold ES, Jahn A, Aderem A, Aitchison J, Rothchild AC, Diercks AH, Nemeth J. A contained Mycobacterium tuberculosis mouse infection model predicts active disease and containment in humans. The Journal of Infectious Diseases. 2021 Mar 10. \url{https://dx.doi.org/10.1093/infdis/jiab13010.1093/infdis/jiab130}
\item \strong{Esmail_203}: Esmail, Hanif, Rachel P. Lai, Maia Lesosky, Katalin A. Wilkinson, Christine M. Graham, Stuart Horswell, Anna K. Coussens, Clifton E. Barry 3rd, Anne O'Garra, and Robert J. Wilkinson. 2018. "Complement Pathway Gene Activation and Rising Circulating Immune Complexes Characterize Early Disease in HIV-Associated Tuberculosis." Proceedings of the National Academy of Sciences of the United States of America 115 (5): E964-73. \url{https://dx.doi.org/10.1073/pnas.171185311510.1073/pnas.1711853115}
\item \strong{Esmail_82}: Esmail, Hanif, Rachel P. Lai, Maia Lesosky, Katalin A. Wilkinson, Christine M. Graham, Stuart Horswell, Anna K. Coussens, Clifton E. Barry 3rd, Anne O'Garra, and Robert J. Wilkinson. 2018. "Complement Pathway Gene Activation and Rising Circulating Immune Complexes Characterize Early Disease in HIV-Associated Tuberculosis." Proceedings of the National Academy of Sciences of the United States of America 115 (5): E964-73. \url{https://dx.doi.org/10.1073/pnas.171185311510.1073/pnas.1711853115}
\item \strong{Esmail_OD_893}: Esmail, Hanif, Rachel P. Lai, Maia Lesosky, Katalin A. Wilkinson, Christine M. Graham, Stuart Horswell, Anna K. Coussens, Clifton E. Barry 3rd, Anne O'Garra, and Robert J. Wilkinson. 2018. "Complement Pathway Gene Activation and Rising Circulating Immune Complexes Characterize Early Disease in HIV-Associated Tuberculosis." Proceedings of the National Academy of Sciences of the United States of America 115 (5): E964-73. \url{https://dx.doi.org/10.1073/pnas.171185311510.1073/pnas.1711853115}
\item \strong{Estevez_133}: Estévez O, Anibarro L, Garet E, et al. An RNA-seq Based Machine Learning Approach Identifies Latent Tuberculosis Patients With an Active Tuberculosis Profile. Front Immunol. 2020;11:1470. Published 2020 Jul 14. \url{https://dx.doi.org/10.3389/fimmu.2020.0147010.3389/fimmu.2020.01470}
\item \strong{Estevez_259}: Estévez O, Anibarro L, Garet E, et al. An RNA-seq Based Machine Learning Approach Identifies Latent Tuberculosis Patients With an Active Tuberculosis Profile. Front Immunol. 2020;11:1470. Published 2020 Jul 14. \url{https://dx.doi.org/10.3389/fimmu.2020.0147010.3389/fimmu.2020.01470}
\item \strong{Francisco_OD_2}: Francisco NM, Fang YM, Ding L, et al. Diagnostic accuracy of a selected signature gene set that discriminates active pulmonary tuberculosis and other pulmonary diseases. J Infect. 2017;75(6):499-510. \url{http://dx.doi.org/10.1016/j.jinf.2017.09.01210.1016/j.jinf.2017.09.012}
\item \strong{Gjoen_10}: Gjøen, J.E., Jenum, S., Sivakumaran, D. et al. 'Novel transcriptional signatures for sputum-independent diagnostics of tuberculosis in children.' Sci Rep 7, 5839 (2017). \url{https://doi.org/10.1038/s41598-017-05057-x10.1038/s41598-017-05057-x}
\item \strong{Gjoen_7}: Gjøen, J.E., Jenum, S., Sivakumaran, D. et al. 'Novel transcriptional signatures for sputum-independent diagnostics of tuberculosis in children.' Sci Rep 7, 5839 (2017). \url{https://doi.org/10.1038/s41598-017-05057-x10.1038/s41598-017-05057-x}
\item \strong{Gliddon_2_OD_4}: Gliddon HD, Kaforou M, Alikian M, et al. Identification of Reduced Host Transcriptomic Signatures for Tuberculosis Disease and Digital PCR-Based Validation and Quantification. Front Immunol. 2021;12:637164. Published 2021 Mar 2. \url{https://dx.doi.org/10.3389/fimmu.2021.63716410.3389/fimmu.2021.637164}
\item \strong{Gliddon_HIV_3}: Gliddon HD, Kaforou M, Alikian M, et al. Identification of Reduced Host Transcriptomic Signatures for Tuberculosis Disease and Digital PCR-Based Validation and Quantification. Front Immunol. 2021;12:637164. Published 2021 Mar 2. \url{https://dx.doi.org/10.3389/fimmu.2021.63716410.3389/fimmu.2021.637164}
\item \strong{Gliddon_OD_3}: Gliddon, Harriet D., Kaforou, Myrsini, Alikian, Mary, Habgood-Coote, Dominic, Zhou, Chenxi, Oni, Tolu, Anderson, Suzanne T., Brent, Andrew J., Crampin, Amelia C., Eley, Brian, Kern, Florian, Langford, Paul R., Ottenhoff, Tom H. M., Hibberd, Martin L., French, Neil, Wright, Victoria J., Dockrell, Hazel M., Coin, Lachlan J., Wilkinson, Robert J., Levin, Michael. 2019 "Identification of reduced host transcriptomic signatures for tuberculosis and digital PCR-based validation and quantification" biorxiv.org: . \url{https://dx.doi.org/10.1101/58367410.1101/583674}
\item \strong{Gliddon_OD_4}: Gliddon, Harriet D., Kaforou, Myrsini, Alikian, Mary, Habgood-Coote, Dominic, Zhou, Chenxi, Oni, Tolu, Anderson, Suzanne T., Brent, Andrew J., Crampin, Amelia C., Eley, Brian, Kern, Florian, Langford, Paul R., Ottenhoff, Tom H. M., Hibberd, Martin L., French, Neil, Wright, Victoria J., Dockrell, Hazel M., Coin, Lachlan J., Wilkinson, Robert J., Levin, Michael. 2019 "Identification of reduced host transcriptomic signatures for tuberculosis and digital PCR-based validation and quantification" biorxiv.org: . \url{https://dx.doi.org/10.1101/58367410.1101/583674}
\item \strong{Gong_OD_4}: Gong Z, Gu Y, Xiong K, Niu J, Zheng R, Su B, Fan L and Xie J (2021) The Evaluation and Validation of Blood-Derived Novel Biomarkers for Precise and Rapid Diagnosis of Tuberculosis in Areas With High-TB Burden. Front. Microbiol. 12:650567. \url{https://dx.doi.org/10.3389/fmicb.2021.65056710.3389/fmicb.2021.650567}
\item \strong{Heycken_FAIL_22}: Heyckendorf J, Marwitz S, Reimann M, et al. Prediction of anti-tuberculosis treatment duration based on a 22-gene transcriptomic model. Eur Respir J. 2021;2003492. \url{https://dx.doi.org/10.1183/13993003.03492-202010.1183/13993003.03492-2020}
\item \strong{Hoang_OD_13}: Hoang, Long & Jain, Pooja & Pillay, Timesh & Tolosa-Wright, Mica & Niazi, Umar & Takwoingi, Yemisi & Halliday, Alice & Berrocal-Almanza, Luis & Deeks, Jonathan & Beverley, Peter & Kon, Onn & Lalvani, Ajit. (2021). Transcriptomic signatures for diagnosing tuberculosis in clinical practice: a prospective, multicentre cohort study. The Lancet Infectious Diseases. \url{https://dx.doi.org/10.1016/S1473-3099(20)30928-210.1016/S1473-3099(20)30928-2}
\item \strong{Hoang_OD_20}: Hoang, Long & Jain, Pooja & Pillay, Timesh & Tolosa-Wright, Mica & Niazi, Umar & Takwoingi, Yemisi & Halliday, Alice & Berrocal-Almanza, Luis & Deeks, Jonathan & Beverley, Peter & Kon, Onn & Lalvani, Ajit. (2021). Transcriptomic signatures for diagnosing tuberculosis in clinical practice: a prospective, multicentre cohort study. The Lancet Infectious Diseases. \url{https://dx.doi.org/10.1016/S1473-3099(20)30928-210.1016/S1473-3099(20)30928-2}
\item \strong{Hoang_OD_3}: Hoang, Long & Jain, Pooja & Pillay, Timesh & Tolosa-Wright, Mica & Niazi, Umar & Takwoingi, Yemisi & Halliday, Alice & Berrocal-Almanza, Luis & Deeks, Jonathan & Beverley, Peter & Kon, Onn & Lalvani, Ajit. (2021). Transcriptomic signatures for diagnosing tuberculosis in clinical practice: a prospective, multicentre cohort study. The Lancet Infectious Diseases. \url{https://dx.doi.org/10.1016/S1473-3099(20)30928-210.1016/S1473-3099(20)30928-2}
\item \strong{Huang_13}: Huang, Hai-Hui et al. 'Identification of 13 Blood-based Gene Expression Signatures to Accurately Distinguish Tuberculosis from Other Pulmonary Diseases and Healthy Controls'. 1 Jan. 2015 : S1837 - S1843.\url{https://doi.org/10.3233/BME-15148610.3233/BME-151486}
\item \strong{Jacobsen_3}: Jacobsen, Marc, Dirk Repsilber, Andrea Gutschmidt, Albert Neher, Knut Feldmann, Hans J. Mollenkopf, Andreas Ziegler, and Stefan H. E. Kaufmann. 2007. "Candidate Biomarkers for Discrimination between Infection and Disease Caused by Mycobacterium Tuberculosis." Journal of Molecular Medicine  85 (6): 613-21. \url{https://dx.doi.org/10.1007/s00109-007-0157-610.1007/s00109-007-0157-6}
\item \strong{Jenum_8}: Jenum, S., Dhanasekaran, S., Lodha, R. et al. Approaching a diagnostic point-of-care test for pediatric tuberculosis through evaluation of immune biomarkers across the clinical disease spectrum. Sci Rep 6, 18520 (2016). \url{https://doi.org/10.1038/srep1852010.1038/srep18520}
\item \strong{Kaforou_27}: Kaforou, Myrsini, Victoria J. Wright, Tolu Oni, Neil French, Suzanne T. Anderson, Nonzwakazi Bangani, Claire M. Banwell, et al. 2013. "Detection of Tuberculosis in HIV-Infected and -Uninfected African Adults Using Whole Blood RNA Expression Signatures: A Case-Control Study." PLoS Medicine 10 (10): e1001538. \url{https://dx.doi.org/10.1371/journal.pmed.100153810.1371/journal.pmed.1001538}
\item \strong{Kaforou_OD_44}: Kaforou, Myrsini, Victoria J. Wright, Tolu Oni, Neil French, Suzanne T. Anderson, Nonzwakazi Bangani, Claire M. Banwell, et al. 2013. "Detection of Tuberculosis in HIV-Infected and -Uninfected African Adults Using Whole Blood RNA Expression Signatures: A Case-Control Study." PLoS Medicine 10 (10): e1001538. \url{https://dx.doi.org/10.1371/journal.pmed.100153810.1371/journal.pmed.1001538}
\item \strong{Kaforou_OD_53}: Kaforou, Myrsini, Victoria J. Wright, Tolu Oni, Neil French, Suzanne T. Anderson, Nonzwakazi Bangani, Claire M. Banwell, et al. 2013. "Detection of Tuberculosis in HIV-Infected and -Uninfected African Adults Using Whole Blood RNA Expression Signatures: A Case-Control Study." PLoS Medicine 10 (10): e1001538. \url{https://dx.doi.org/10.1371/journal.pmed.100153810.1371/journal.pmed.1001538}
\item \strong{Kaul_3}: Kaul S, Nair V, Birla S, et al. Latent Tuberculosis Infection Diagnosis among Household Contacts in a High Tuberculosis-Burden Area: a Comparison between Transcript Signature and Interferon Gamma Release Assay. Microbiol Spectr. 2022;10(2):e0244521. \url{http://dx.doi.org/10.1128/spectrum.02445-2110.1128/spectrum.02445-21}
\item \strong{Kulkarni_HIV_2}: Kulkarni V, Queiroz ATL, Sangle S, et al. A Two-Gene Signature for Tuberculosis Diagnosis in Persons With Advanced HIV. Front Immunol. 2021;12:631165. Published 2021 Feb 22. \url{https://dx.doi.org/10.3389/fimmu.2021.63116510.3389/fimmu.2021.631165}
\item \strong{Kwan_186}: Kwan PKW, Periaswamy B, De Sessions PF, et al. A blood RNA transcript signature for TB exposure in household contacts. BMC Infect Dis. 2020;20(1):403. \url{http://dx.doi.org/10.1186/s12879-020-05116-110.1186/s12879-020-05116-1}
\item \strong{LauxdaCosta_OD_3}: Laux da Costa L, Delcroix M, Dalla Costa ER, et al. A real-time PCR signature to discriminate between tuberculosis and other pulmonary diseases. Tuberculosis (Edinb). 2015;95(4):421-425. \url{https://dx.doi.org/10.1016/j.tube.2015.04.00810.1016/j.tube.2015.04.008}
\item \strong{Lee_4}: Lee, Shih-Wei, Lawrence Shih-Hsin Wu, Guan-Mau Huang, Kai-Yao Huang, Tzong-Yi Lee, and Julia Tzu-Ya Weng. 2016. "Gene Expression Profiling Identifies Candidate Biomarkers for Active and Latent Tuberculosis." BMC Bioinformatics 17 Suppl 1 (January): 3. \url{https://dx.doi.org/10.1186/s12859-015-0848-x10.1186/s12859-015-0848-x}
\item \strong{Leong_24}: Leong, Samantha, Yue Zhao, Noyal M. Joseph, Natasha S. Hochberg, Sonali Sarkar, Jane Pleskunas, David Hom, et al. 2018. "Existing blood transcriptional classifiers accurately discriminate active tuberculosis from latent infection in individuals from south India." Tuberculosis (109): 41-51. \url{https://doi.org/10.1016/j.tube.2018.01.00210.1016/j.tube.2018.01.002}
\item \strong{PREDICT29}: Leong, S., Zhao, Y., Ribeiro-Rodrigues, R., Jones-López, E. C., Acuña-Villaorduña, C., Rodrigues, P. M., Palaci, M., Alland, D., Dietze, R., Ellner, J. J., Johnson, W. E., Salgame, P., Cross-validation of existing signatures and derivation of a novel 29-gene transcriptomic signature predictive of progression to TB in a Brazilian cohort of household contacts of pulmonary TB. Tuberculosis (Edinb). 2020 Jan;120:101898. \url{https://dx.doi.org/10.1016/j.tube.2020.10189810.1016/j.tube.2020.101898}
\item \strong{Li_3}: Li M, Qiu Y, Guo M, Qu R, Tian F, Wang G, Wang Y, Ma J, Liu S, Takiff H, Tang Y, Gao Q.2023.Evaluation of the Cepheid 3-gene host response blood test for tuberculosis diagnosis and treatment response monitoring in a primary-level clinic in rural China. J Clin Microbiol61:e00911-23. \url{http://dx.doi.org/10.1128/jcm.00911-23}
\item \strong{Long_RES_10}: Long NP, Phat NK, Yen NTH, et al. A 10-gene biosignature of tuberculosis treatment monitoring and treatment outcome prediction. Tuberculosis (Edinb). 2021;131:102138. \url{http://dx.doi.org/10.1016/j.tube.2021.10213810.1016/j.tube.2021.102138}
\item \strong{Maertzdorf_15}: Maertzdorf J, McEwen G, Weiner J 3rd, et al. Concise gene signature for point-of-care classification of tuberculosis. EMBO Mol Med. 2016;8(2):86-95. \url{https://dx.doi.org/10.15252/emmm.20150579010.15252/emmm.201505790}
\item \strong{DIAG4}: Maertzdorf, Jeroen, Gayle McEwen, January Weiner 3rd, Song Tian, Eric Lader, Ulrich Schriek, Harriet Mayanja-Kizza, Martin Ota, John Kenneth, and Stefan He Kaufmann. 2016. "Concise Gene Signature for Point-of-Care Classification of Tuberculosis." EMBO Molecular Medicine 8 (2): 86-95. \url{https://dx.doi.org/10.15252/emmm.20150579010.15252/emmm.201505790}
\item \strong{Maertzdorf_OD_100}: Maertzdorf, Jeroen, January Weiner 3rd, Hans-Joachim Mollenkopf, TBornot TB Network, Torsten Bauer, Antje Prasse, Joachim Müller-Quernheim, and Stefan H. E. Kaufmann. 2012. "Common Patterns and Disease-Related Signatures in Tuberculosis and Sarcoidosis." Proceedings of the National Academy of Sciences of the United States of America 109 (20): 7853-58. \url{https://dx.doi.org/10.1073/pnas.112107210910.1073/pnas.1121072109}
\item \strong{Natarajan_7}: Natarajan S, Ranganathan M, Hanna LE, Tripathy S. Transcriptional Profiling and Deriving a Seven-Gene Signature That Discriminates Active and Latent Tuberculosis: An Integrative Bioinformatics Approach. Genes (Basel). 2022;13(4):616. Published 2022 Mar 29. \url{http://dx.doi.org/10.3390/genes1304061610.3390/genes13040616}
\item \strong{RISK6}: Penn-Nicholson, A. et al. RISK6, a 6-gene transcriptomic signature of TB disease risk, diagnosis and treatment response. Sci. Rep. 10, (2020). \url{https://dx.doi.org/10.1038/s41598-020-65043-810.1038/s41598-020-65043-8}
\item \strong{Qian_OD_17}: Qian, Zhongqing et al. "Expression of nuclear factor, erythroid 2-like 2-mediated genes differentiates tuberculosis." Tuberculosis (Edinburgh, Scotland) vol. 99 (2016): 56-62. \url{https://doi.org/10.1016/j.tube.2016.04.00810.1016/j.tube.2016.04.008}
\item \strong{Rajan_HIV_5}: Rajan, Jayant V., Semitala, Fred C., Kamya, Moses R., Yoon, Christina., Mehta, Tejas., Cattamanchi, Adithya., Seielstad, Mark., Montalvo, Lani., Andama, Alfred., Katende, Jane., Asege, Lucy., Nakaye, Martha., Mwebe, Sandra. 2018 "A Novel, 5-Transcript, Whole-blood Gene-expression Signature for Tuberculosis Screening Among People Living With Human Immunodeficiency Virus" Clinical Infectious Diseases: 1-7. \url{https://doi.org/10.1093/cid/ciy83510.1093/cid/ciy835}
\item \strong{Roe_3}: Roe, Jennifer, Venturini, Cristina, Gupta, Rishi K., Gurry, Celine, Chain, Benjamin M., Sun, Yuxin, Southern, Jo, Jackson, Charlotte, Lipman, Marc, C., Miller, Robert F., Martineau, Adrian R., Abubakar, Ibrahim, Noursadeghi, Mahdad. 2019 "T1 Blood transcriptomic stratification of short-term risk in contacts of tuberculosis": . \url{https://doi.org/10.1093/cid/ciz25210.1093/cid/ciz252}
\item \strong{Roe_OD_4}: Roe, Jennifer K., Niclas Thomas, Eliza Gil, Katharine Best, Evdokia Tsaliki, Stephen Morris-Jones, Sian Stafford, et al. 2016. "Blood Transcriptomic Diagnosis of Pulmonary and Extrapulmonary Tuberculosis." JCI Insight 1 (16): e87238. \url{https://dx.doi.org/10.1172/jci.insight.8723810.1172/jci.insight.87238}
\item \strong{Sambarey_HIV_10}: Sambarey, Awanti, Abhinandan Devaprasad, Abhilash Mohan, Asma Ahmed, Soumya Nayak, Soumya Swaminathan, George D'Souza, et al. 2017. "Unbiased Identification of Blood-Based Biomarkers for Pulmonary Tuberculosis by Modeling and Mining Molecular Interaction Networks." EBioMedicine 15 (February): 112-26. \url{https://dx.doi.org/10.1016/j.ebiom.2016.12.00910.1016/j.ebiom.2016.12.009}
\item \strong{Singhania_OD_20}: Singhania, Akul, Raman Verma, Christine M. Graham, Jo Lee, Trang Tran, Matthew Richardson, Patrick Lecine, et al. 2018. "A Modular Transcriptional Signature Identifies Phenotypic Heterogeneity of Human Tuberculosis Infection." Nature Communications 9 (1): 2308. \url{https://dx.doi.org/10.1038/s41467-018-04579-w10.1038/s41467-018-04579-w}
\item \strong{Sivakumaran_11}: Sivakumaran D, Ritz C, Gjøen JE, et al. Host Blood RNA Transcript and Protein Signatures for Sputum-Independent Diagnostics of Tuberculosis in Adults. Front Immunol. 2021;11:626049. Published 2021 Feb 4. \url{https://dx.doi.org/10.3389/fimmu.2020.62604910.3389/fimmu.2020.626049}
\item \strong{Sloot_HIV_2}: Sloot, Rosa, Maarten F. Schim van der Loeff, Erik W. van Zwet, Mariëlle C. Haks, Sytze T. Keizer, Maarten Scholing, Tom H. M. Ottenhoff, Martien W. Borgdorff, and Simone A. Joosten. 2015. "Biomarkers Can Identify Pulmonary Tuberculosis in HIV-Infected Drug Users Months Prior to Clinical Diagnosis." EBioMedicine 2 (2): 172-79. \url{https://dx.doi.org/10.1016/j.ebiom.2014.12.00110.1016/j.ebiom.2014.12.001}
\item \strong{Suliman_4}: Suliman, Sara, Ethan Thompson, Jayne Sutherland, January Weiner Rd, Martin O. C. Ota, Smitha Shankar, Adam Penn-Nicholson, et al. 2018. "Four-Gene Pan-African Blood Signature Predicts Progression to Tuberculosis." American Journal of Respiratory and Critical Care Medicine, April. https://doi.org/10.1164/rccm.201711-2340OC. \url{https://dx.doi.org/10.1164/rccm.201711-2340OC10.1164/rccm.201711-2340OC}
\item \strong{Suliman_RISK_2}: Suliman, S. et al. Four-gene pan-African blood signature predicts progression to tuberculosis. Am. J. Respir. Crit. Care Med. 197, 1198-1208 (2018). \url{https://dx.doi.org/10.1164/rccm.201711-2340OC10.1164/rccm.201711-2340OC}
\item \strong{RISK4}: Suliman, Sara, Ethan Thompson, Jayne Sutherland, January Weiner Rd, Martin O. C. Ota, Smitha Shankar, Adam Penn-Nicholson, et al. 2018. "Four-Gene Pan-African Blood Signature Predicts Progression to Tuberculosis." American Journal of Respiratory and Critical Care Medicine, April. https://doi.org/10.1164/rccm.201711-2340OC. \url{https://dx.doi.org/10.1164/rccm.201711-2340OC10.1164/rccm.201711-2340OC}
\item \strong{DIAG3}: Sweeney, Timothy E., Lindsay Braviak, Cristina M. Tato, and Purvesh Khatri. 2016. "Genome-Wide Expression for Diagnosis of Pulmonary Tuberculosis: A Multicohort Analysis." The Lancet. Respiratory Medicine 4 (3): 213-24. \url{https://dx.doi.org/10.1016/S2213-2600(16)00048-510.1016/S2213-2600(16)00048-5}
\item \strong{TB12}: Tabone O, Verma R, Singhania A, et al. Blood transcriptomics reveal the evolution and resolution of the immune response in tuberculosis. J Exp Med. 2021;218(10):e20210915. \url{http://dx.doi.org/10.1084/jem.2021091510.1084/jem.20210915}
\item \strong{EarlyRESP-TB25}: Tabone O, Verma R, Singhania A, et al. Blood transcriptomics reveal the evolution and resolution of the immune response in tuberculosis. J Exp Med. 2021;218(10):e20210915. \url{http://dx.doi.org/10.1084/jem.2021091510.1084/jem.20210915}
\item \strong{TREAT-TB27}: Tabone O, Verma R, Singhania A, et al. Blood transcriptomics reveal the evolution and resolution of the immune response in tuberculosis. J Exp Med. 2021;218(10):e20210915. \url{http://dx.doi.org/10.1084/jem.2021091510.1084/jem.20210915}
\item \strong{DISEASE}: Thompson, Ethan G., Ying Du, Stephanus T. Malherbe, Smitha Shankar, Jackie Braun, Joe Valvo, Katharina Ronacher, et al. 2017. "Host Blood RNA Signatures Predict the Outcome of Tuberculosis Treatment." Tuberculosis  107 (December): 48-58. \url{https://dx.doi.org/10.1016/j.tube.2017.08.00410.1016/j.tube.2017.08.004}
\item \strong{FAILURE}: Thompson, Ethan G., Ying Du, Stephanus T. Malherbe, Smitha Shankar, Jackie Braun, Joe Valvo, Katharina Ronacher, et al. 2017. "Host Blood RNA Signatures Predict the Outcome of Tuberculosis Treatment." Tuberculosis  107 (December): 48-58. \url{https://dx.doi.org/10.1016/j.tube.2017.08.00410.1016/j.tube.2017.08.004}
\item \strong{RESPONSE5}: Thompson, Ethan G., Ying Du, Stephanus T. Malherbe, Smitha Shankar, Jackie Braun, Joe Valvo, Katharina Ronacher, et al. 2017. "Host Blood RNA Signatures Predict the Outcome of Tuberculosis Treatment." Tuberculosis  107 (December): 48-58. \url{https://dx.doi.org/10.1016/j.tube.2017.08.00410.1016/j.tube.2017.08.004}
\item \strong{Tornheim_71}: Tornheim, Jeffrey A., Anil K. Madugundu, Mandar Paradkar, Kiyoshi F. Fukutani, Artur TL Queiroz, Nikhil Gupte, Akshay N. Gupte et al. 2020. "Transcriptomic Profiles of Confirmed Pediatric Tuberculosis Patients and Household Contacts Identifies Active Tuberculosis, Infection, and Treatment Response Among Indian Children." The Journal of Infectious Diseases 221(10): 1647-1658. \url{https://doi.org/10.1093/infdis/jiz63910.1093/infdis/jiz639}
\item \strong{Tornheim_RES_25}: Tornheim, Jeffrey A., Anil K. Madugundu, Mandar Paradkar, Kiyoshi F. Fukutani, Artur TL Queiroz, Nikhil Gupte, Akshay N. Gupte et al. 2020. "Transcriptomic Profiles of Confirmed Pediatric Tuberculosis Patients and Household Contacts Identifies Active Tuberculosis, Infection, and Treatment Response Among Indian Children." The Journal of Infectious Diseases 221(10): 1647-1658. \url{https://doi.org/10.1093/infdis/jiz63910.1093/infdis/jiz639}
\item \strong{Vargas_18}: Vargas R, Abbott L, Bower D, Frahm N, Shaffer M, Yu WH. Gene signature discovery and systematic validation across diverse clinical cohorts for TB prognosis and response to treatment. PLoS Comput Biol. 2023;19(7):e1010770. \url{http://dx.doi.org/10.1371/journal.pcbi.101077010.1371/journal.pcbi.1010770}
\item \strong{Vargas_42}: Vargas R, Abbott L, Bower D, Frahm N, Shaffer M, Yu WH. Gene signature discovery and systematic validation across diverse clinical cohorts for TB prognosis and response to treatment. PLoS Comput Biol. 2023;19(7):e1010770. \url{http://dx.doi.org/10.1371/journal.pcbi.101077010.1371/journal.pcbi.1010770}
\item \strong{Verhagen_10}: Verhagen, L.M., Zomer, A., Maes, M. et al. A predictive signature gene set for discriminating active from latent tuberculosis in Warao Amerindian children. BMC Genomics 14, 74 (2013). \url{https://doi.org/10.1186/1471-2164-14-7410.1186/1471-2164-14-74}
\item \strong{Walter_51}: Walter, Nicholas D., Mikaela A. Miller, Joshua Vasquez, Marc Weiner, Adam Chapman, Melissa Engle, Michael Higgins, et al. 2016. "Blood Transcriptional Biomarkers for Active Tuberculosis among Patients in the United States: A Case-Control Study with Systematic Cross-Classifier Evaluation." Journal of Clinical Microbiology 54 (2): 274-82. \url{https://dx.doi.org/10.1128/JCM.01990-1510.1128/JCM.01990-15}
\item \strong{Walter_PNA_119}: Walter, Nicholas D., Mikaela A. Miller, Joshua Vasquez, Marc Weiner, Adam Chapman, Melissa Engle, Michael Higgins, et al. 2016. "Blood Transcriptional Biomarkers for Active Tuberculosis among Patients in the United States: A Case-Control Study with Systematic Cross-Classifier Evaluation." Journal of Clinical Microbiology 54 (2): 274-82. \url{https://dx.doi.org/10.1128/JCM.01990-1510.1128/JCM.01990-15}
\item \strong{Walter_PNA_47}: Walter, Nicholas D., Mikaela A. Miller, Joshua Vasquez, Marc Weiner, Adam Chapman, Melissa Engle, Michael Higgins, et al. 2016. "Blood Transcriptional Biomarkers for Active Tuberculosis among Patients in the United States: A Case-Control Study with Systematic Cross-Classifier Evaluation." Journal of Clinical Microbiology 54 (2): 274-82. \url{https://dx.doi.org/10.1128/JCM.01990-1510.1128/JCM.01990-15}
\item \strong{ACS_COR}: Zak, Daniel E., Adam Penn-Nicholson, Thomas J. Scriba, Ethan Thompson, Sara Suliman, Lynn M. Amon, Hassan Mahomed, et al. 2016. "A Blood RNA Signature for Tuberculosis Disease Risk: A Prospective Cohort Study." The Lancet 387 (10035): 231222. \url{https://dx.doi.org/10.1016/S0140-6736(15)01316-110.1016/S0140-6736(15)01316-1}
\item \strong{Zhao_NANO_6}: Kaipilyawar, Vaishnavi, et al. Development and Validation of a Parsimonious Tuberculosis Gene Signature Using the digital NanoString nCounter Platform. Clinical Infectious Diseases 75.6 (2022): 1022-1030. \url{http://dx.doi.org/10.1093/cid/ciac010}
}
}
\usage{
TBcommon
}
\description{
A set of Tuberculosis gene signatures from various publications. This set
of signatures uses gene symbols. Attempts have been made to use updated gene
symbols and remove symbols that did not match the most recent annotation.
Additional sets for Entrez IDs and Ensembl IDs are forthcoming.
}
\details{
This list differs from \code{TBsignatures} in that signatures with names
specified in their originating publication (or that of a peer)
are given that common name rather than using the \code{TBSignatureProfiler}
naming system. Otherwise, signature names are composed of the last name
of the primary author, followed by
a possible context for the signature, and ending with either the number of
gene transcripts or genes in the signature with respect to however
it was described in the original publication.

Possible signature contexts:
\itemize{
\item \code{<blank>}: TB vs LTBI or Healthy Controls
\item OD: Other diseases
\item HIV: Human Immunodeficiency Virus
\item PNA: Pneumonia
\item RISK: Risk of developing active TB
\item RES: Response to TB treatment
\item FAIL: Failure of TB treatment
}

Note that in some cases signatures will be positive identifiers of TB
whereas others are negative identifiers; this should be taken into account
when creating ROC curves and computing any AUC estimates.
}
\examples{
data("TBcommon")
}
\keyword{datasets}
