% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OriginalModel.R
\name{ObtainSampleScore_OriginalModel}
\alias{ObtainSampleScore_OriginalModel}
\title{Obtain training data, testing data, and train signature's original model.}
\usage{
ObtainSampleScore_OriginalModel(
  theObject_train,
  useAssay,
  gene_set,
  input,
  SigName,
  obtainDiagnosis,
  annotationColName,
  FUN,
  adj
)
}
\arguments{
\item{theObject_train}{A SummarizedExperiment object that has been pre-stored in the
data file: OriginalTrainingData.}

\item{useAssay}{A character string or an integer specifying the assay in the \code{input}.
Used for the test SummarizedExperiment object. Default is 1, indicating the first assay
in the test SummarizedExperiment object.}

\item{gene_set}{A character vector that includes gene symbols for selected gene signature.}

\item{input}{A SummarizedExperiment object with gene symbols as the assay row names.}

\item{SigName}{Optional. A character string that indicates the name for \code{gene_set}.
\code{SigName} is used to provide information when gene signatures were missing
in the test data.}

\item{obtainDiagnosis}{Boolean. Used to create training data if TRUE. Default is FALSE}

\item{annotationColName}{A character string specifying the column name of disease status.
Only used when creating training data. Default is NULL.}

\item{FUN}{A character string specifying the function name of the corresponding signature's original model.}

\item{adj}{A small real number used in combat to solve for genes with 0 counts in rare cases.
Not required for most of cases.}
}
\value{
The predicted score for each sample in the test study using corresponding gene signature's original model.
}
\description{
Obtain training data, testing data, and train signature's original model.
}
