% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMultipleProtein.R
\name{plotMultipleProtein}
\alias{plotMultipleProtein}
\title{Visualization of multiple protein localizations}
\usage{
plotMultipleProtein(sampleClassification, proteinList)
}
\arguments{
\item{sampleClassification}{data.frame; merged classification,
combination of compartment and neighborhood classifications
per protein.}

\item{proteinList}{vector; protein gene symbol names.}
}
\value{
multipleProt.df
}
\description{
Distributions of subcellular localizations
of multiple proteins both ar the
compartment and neighborhood level are plotted.
}
\examples{
{

proteasome26s <- c("PSMA7", "PSMC3", "PSMB1", "PSMA1", "PSMA3","PSMA4",
"PSMA5", "PSMB4", "PSMB6", "PSMB5","PSMC2", "PSMC4", "PSMB3", "PSMB2",
"PSMD4", "PSMA6", "PSMC1", "PSMC5", "PSMC6", "PSMB7", "PSMD13")

exp.cls.df <- SubCellBarCode::hcc827GEFClass

multipleProt.df <- plotMultipleProtein(exp.cls.df, proteasome26s )

}
}
