% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBarcode.R
\name{plotBarcode}
\alias{plotBarcode}
\title{Visualize the SubCellBarCode}
\usage{
plotBarcode(sampleClassification, protein, s1PSM)
}
\arguments{
\item{sampleClassification}{data.frame; merged classification,
combination of compartment and neighborhood classification.}

\item{protein}{character; protein gene symbol name}

\item{s1PSM}{data.frame; minimum PSM count table. Row names should
be gene centric protein id.}
}
\value{
proteinPlot
}
\description{
Stacked bar plot are plotted for compartment and
neighborhood level with respect to classification probabilities.
}
\examples{
{

#create mock data
plot.df <- data.frame(Protein = "TP53",
NeighborhoodCls = "Nuclear",
CompartmentCls = "N1",
Secretory = as.numeric(0.01),
Nuclear = as.numeric(0.95),
Cytosol = as.numeric(0.02),
Mitochondria = as.numeric(0.02),
S1 = as.numeric(0.02),
S2 = as.numeric(0.02),
S3 = as.numeric(0.02),
S4 = as.numeric(0.02),
N1 = as.numeric(0.72),
N2 = as.numeric(0.02),
N3 = as.numeric(0.02),
N4 = as.numeric(0.02),
C1 = as.numeric(0.02),
C2 = as.numeric(0.02),
C3 = as.numeric(0.02),
C4 = as.numeric(0.02),
C5 = as.numeric(0.02),
M1 = as.numeric(0.02),
M2 = as.numeric(0.02))

rownames(plot.df) <- "TP53"

psm.df <- data.frame(Protein = "TP53",
PSMs.for.quant = as.numeric(31))

rownames(psm.df) <- "TP53"

proteinPlot <- plotBarcode(plot.df, "TP53", psm.df)
}
}
