% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statial.R
\name{getDistances}
\alias{getDistances}
\title{Wrapper to calculate pairwise distance between cell types by image}
\usage{
getDistances(
  cells,
  maxDist = NULL,
  imageID = "imageID",
  spatialCoords = c("x", "y"),
  cellType = "cellType",
  redDimName = "distances",
  distFun = "min",
  nCores = 1
)
}
\arguments{
\item{cells}{A dataframe with a cellType column as well as x and y spatial coordinates.
The dataframe must contain a imageID column and cellID (unique cell
identifier's) column as well}

\item{maxDist}{The maximum distance considered.}

\item{imageID}{The name of the colData column that stores in the image ID.}

\item{spatialCoords}{The columns that store the spatial coordinates.}

\item{cellType}{The name of the colData column that stores the cell types.}

\item{redDimName}{The name of the reduced dimension to store the distances in.}

\item{distFun}{What distance function to use. Can be min or abundance.}

\item{nCores}{Number of cores for parallel processing.}
}
\description{
Calculates the euclidean distance from each cell to the nearest cell of each
type
}
\examples{
data("kerenSCE")

kerenSCE <- getDistances(kerenSCE,
  maxDist = 200
)

}
