% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_method.R
\name{calculate_method}
\alias{calculate_method}
\title{Calculate diversity values for a matrix of transcripts.}
\usage{
calculate_method(x, genes, method, norm = TRUE, verbose = FALSE)
}
\arguments{
\item{x}{An input \code{matrix}, or \code{data.frame} containing
transcript-level expression values.}

\item{genes}{Character vector with equal length to the number of rows of the
input dataset with transcript-level expression values. The values in
\code{x} are grouped into genes based on this vector.}

\item{method}{Method to use for splicing diversity calculation, including
naive entropy (\code{naive}), Laplace entropy (\code{laplace}), Gini index
(\code{gini}), Simpson index (\code{simpson}) and inverse Simpson index
(\code{invsimpson}). The default method is Laplace entropy.}

\item{norm}{If \code{TRUE}, the entropy values are normalized to the number
of transcripts for each gene. The normalized entropy values are always
between 0 and 1. If \code{FALSE}, genes cannot be compared to each other,
due to possibly different maximum entropy values.}

\item{verbose}{If \code{TRUE}, the function will print additional diagnostic
messages, besides the warnings and errors.}
}
\value{
Gene-level splicing diversity values in a \code{data.frame}, where
  each row belongs to a gene and each column belongs to a sample from the
  data, in addition to the first column, containing gene names, given in the
  `genes` parameter.
}
\description{
Calculate diversity values for a matrix of transcripts.
}
\details{
The function calculates diversity values on a matrix of
transcript-level expression values, aggregated by the genes defined in the
\code{genes} parameter.
}
