% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpectralTAD.R
\name{SpectralTAD}
\alias{SpectralTAD}
\title{Hierarchical Spectral Clustering of TADs}
\usage{
SpectralTAD(
  cont_mat,
  chr,
  levels = 1,
  qual_filter = FALSE,
  z_clust = FALSE,
  eigenvalues = 2,
  min_size = 5,
  window_size = 25,
  resolution = "auto",
  gap_threshold = 1,
  grange = FALSE,
  out_format = "none",
  out_path = chr
)
}
\arguments{
\item{cont_mat}{Contact matrix in either sparse 3 column, n x n or n x (n+3)
form where the first three columns are coordinates in BED format.
If an x n matrix is used, the column names must correspond to the start
point of the corresponding bin. If large mode is selected, then
this matrix must be a tab-seperated n x n or n x (n+3) and it should be the 
path to a contact matrix. Required.}

\item{chr}{The chromosome of the contact matrix being analyzed. Required.}

\item{levels}{The number of levels of the TAD hierarchy to be calculated.
The default setting is 1.}

\item{qual_filter}{Option to turn on quality filtering which removes TADs
with negative silhouette scores (poorly organized TADs). Default is FALSE.}

\item{z_clust}{Option to filter sub-TADs based on the z-score of
their eigenvector gaps. Default is TRUE.}

\item{eigenvalues}{The number of eigenvectors to be calculated.
The default and suggested setting is 2.}

\item{min_size}{The minimum allowable TAD size measured in bins. Default is 5.}

\item{window_size}{The size of the sliding window for calculating TADs.
Smaller window sizes correspond to less noise from long-range contacts
but limit the possible size of TADs}

\item{resolution}{The resolution of the contact matrix. If none selected,
the resolution is estimated by taking the most common distance between bins.
For n x (n+3) contact matrices, this value is automatically calculated
from the first three columns.}

\item{gap_threshold}{Corresponds to the percentage of zeros allowed before
a column/row is removed from the analysis. 1=100\%, .7 = 70\%, etc. Default is 1.}

\item{grange}{Parameter to determine whether the result should be a 
GRangeList object. Defaults to FALSE}

\item{out_format}{Specifies the format of the file which SpectralTAD outputs. If
"none, no file is output. "juicebox" or "bedpe" returns a bedpe file 
compatible with juicebox. "hicexplorer" or "bed" returns a bed file compatible with 
 hicexplorer. Default is none}

\item{out_path}{Path of output file. Default is the chromosome}
}
\value{
A list where each entry is in BED format corresponding to the level of the hierarchy.
}
\description{
Hierarchical Spectral Clustering of TADs
}
\details{
Given a sparse 3 column, an n x n contact matrix,
or n x (n+3) contact matrix, SpectralTAD returns a list of TAD coordinates
in BED format. SpectralTAD works by using a sliding window that moves along
the diagonal of the contact matrix. By default, we use the biologically
relevant maximum TAD size of 2Mb and minimum size of 5 bins to determine
the size of this window. Within each window, we calculate a Laplacian matrix
and determine the location of TAD boundaries based on gaps between
eigenvectors calculated from this matrix. The number of TADs in a given
window is calculated by finding the number that maximizes the silhouette score.
A hierarchy of TADs is created by iteratively applying the function to
sub-TADs. The number of levels in each hierarchy is determined by the user.
}
\examples{
#Read in data
data("rao_chr20_25_rep")
#Find TADs
spec_table <- SpectralTAD(rao_chr20_25_rep, chr= 'chr20')
}
