% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra.R
\name{processingChunkSize,Spectra-method}
\alias{processingChunkSize,Spectra-method}
\alias{processingChunkSize}
\alias{processingChunkSize<-}
\alias{processingChunkFactor}
\alias{processingChunkSize<-,Spectra-method}
\alias{processingChunkFactor,Spectra-method}
\alias{backendBpparam,Spectra-method}
\title{Parallel and chunk-wise processing of \code{Spectra}}
\usage{
\S4method{processingChunkSize}{Spectra}(object)

\S4method{processingChunkSize}{Spectra}(object) <- value

\S4method{processingChunkFactor}{Spectra}(object)

\S4method{backendBpparam}{Spectra}(object, BPPARAM = bpparam())
}
\arguments{
\item{object}{\code{Spectra} object.}

\item{value}{\code{integer(1)} defining the chunk size.}

\item{BPPARAM}{Parallel setup configuration. See \code{\link[BiocParallel:register]{BiocParallel::bpparam()}}
for more information.}
}
\value{
\code{processingChunkSize()} returns the currently defined processing
chunk size (or \code{Inf} if it is not defined). \code{processingChunkFactor()}
returns a \code{factor} defining the chunks into which \code{x} will be split
for (parallel) chunk-wise processing or a \code{factor} of length 0 if
no splitting is defined.
}
\description{
Many operations on \code{Spectra} objects, specifically those working with
the actual MS data (peaks data), allow a chunk-wise processing in which
the \code{Spectra} is splitted into smaller parts (chunks) that are
iteratively processed. This enables parallel processing of the data (by
data chunk) and also reduces the memory demand  since only the MS data
of the currently processed subset is loaded into memory and processed.
This chunk-wise processing, which is by default disabled, can be enabled
by setting the processing chunk size of a \code{Spectra} with the
\code{processingChunkSize()} function to a value which is smaller than the
length of the \code{Spectra} object. Setting \code{processingChunkSize(sps) <- 1000}
will cause any data manipulation operation on the \code{sps}, such as
\code{filterIntensity()} or \code{bin()}, to be performed eventually in parallel for
sets of 1000 spectra in each iteration.

Such chunk-wise processing is specifically useful for \code{Spectra} objects
using an \emph{on-disk} backend or for very large experiments. For small data
sets or \code{Spectra} using an in-memory backend, a direct processing might
however be more efficient. Setting the chunk size to \code{Inf} will disable
the chunk-wise processing.

For some backends a certain type of splitting and chunk-wise processing
might be preferable. The \code{MsBackendMzR} backend for example needs to load
the MS data from the original (mzML) files, hence chunk-wise processing
on a per-file basis would be ideal. The \code{\link[=backendParallelFactor]{backendParallelFactor()}} function
for \code{MsBackend} allows backends to suggest a preferred splitting of the
data by returning a \code{factor} defining the respective data chunks. The
\code{MsBackendMzR} returns for example a \code{factor} based on the \emph{dataStorage}
spectra variable. A \code{factor} of length 0 is returned if no particular
preferred splitting should be performed. The suggested chunk definition
will be used if no finite \code{processingChunkSize()} is defined. Setting
the \code{processingChunkSize} overrides \code{backendParallelFactor}.

See the \emph{Large-scale data handling and processing with Spectra} for more
information and examples.

Functions to configure parallel or chunk-wise processing:
\itemize{
\item \code{processingChunkSize()}: allows to get or set the size of the chunks for
parallel processing or chunk-wise processing of a \code{Spectra} in general.
With a value of \code{Inf} (the default) no chunk-wise processing will be
performed.
\item \code{processingChunkFactor()}: returns a \code{factor} defining the chunks into
which a \code{Spectra} will be split for chunk-wise (parallel) processing.
A \code{factor} of length 0 indicates that no chunk-wise processing will be
performed.
}
}
\note{
Some backends might not support parallel processing at all.
For these, the \code{backendBpparam()} function will always return a
\code{SerialParam()} independently on how parallel processing was defined.
}
\author{
Johannes Rainer
}
