% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingBasics.R
\name{fluorLegend}
\alias{fluorLegend}
\title{Add legend of fluorescence targets that make up image}
\usage{
fluorLegend(overlay, nrow = 4, textSize = 10, boxColor = "grey", alpha = 0.25)
}
\arguments{
\item{overlay}{SpatialOverlay}

\item{nrow}{number of rows in the legend. Most studies have 4 which is 
where the values came from: 
1 = horizontal legend, 4 = vertical legend, 2 = box legend}

\item{textSize}{font size}

\item{boxColor}{color of box behind legend}

\item{alpha}{alpha value of box behind legend}
}
\value{
gp of fluorescence legend
}
\description{
Creates legend that can be overlayed on image using \code{cowplot}.
}
\examples{

muBrain <- readRDS(unzip(system.file("extdata", "muBrainSubset_SpatialOverlay.zip",
                                    package = "SpatialOmicsOverlay")))

# image <- downloadMouseBrainImage()

# muBrain <- addImageOmeTiff(overlay = muBrain, 
#                           ometiff = image, res = 8)
                             
gp <- plotSpatialOverlay(overlay = muBrain,   
                         hiRes = FALSE, scaleBar = FALSE)
                         
legend <- fluorLegend(muBrain, nrow = 2, textSize = 3, boxColor = "red")

cowplot::ggdraw() + 
    cowplot::draw_plot(gp) +
    cowplot::draw_plot(legend, scale = 0.12, x = -0.3, y = -0.25)

}
