% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_profile_matrix.R
\name{create_profile_matrix}
\alias{create_profile_matrix}
\title{Create Custom Cell Profile Matrix}
\usage{
create_profile_matrix(
  mtx,
  cellAnnots,
  cellTypeCol,
  cellNameCol,
  matrixName = "Custom",
  outDir = "./",
  geneList = NULL,
  normalize = FALSE,
  scalingFactor = 5,
  minCellNum = 15,
  minGenes = 100,
  discardCellTypes = FALSE
)
}
\arguments{
\item{mtx}{gene x cell count matrix}

\item{cellAnnots}{cell annotations with cell type and cell name as columns}

\item{cellTypeCol}{column containing cell type}

\item{cellNameCol}{column containing cell ID/name}

\item{matrixName}{name of final profile matrix}

\item{outDir}{path to desired output directory, set to NULL if matrix should not be written}

\item{geneList}{gene list to filter profile matrix to}

\item{normalize}{Should data be normalized? (TRUE/FALSE) if TRUE data will be normalize using total gene count}

\item{scalingFactor}{what should all values be multiplied by for final matrix, set to 1 if no scaling is wanted}

\item{minCellNum}{minimum number of cells of one type needed to create profile, exclusive}

\item{minGenes}{minimum number of genes expressed in a cell, exclusive}

\item{discardCellTypes}{should cell types be filtered for types like mitotic, doublet, low quality, unknown, etc.}
}
\value{
A custom cell profile matrix genes (rows) by cell types (columns), matrix gets written to disk and outDir
}
\description{
Create custom cell profile matrix using single cell data. The average gene expression for each cell type is returned.
}
\examples{
cellNames <- paste0("Cell", seq_len(1500))
geneNames <- paste0("Gene", seq_len(1500))
mtx <- matrix(data=sample(size = length(cellNames)*length(geneNames),
                          replace = TRUE,
                          x = c(0,seq_len(100)), 
                          prob = c(0.6784, rep(0.0075, 15), rep(0.005, 25),
                                   rep(0.002, 25), rep(0.001, 35))), 
                          ncol = length(cellNames), nrow = length(geneNames), 
                          dimnames = list(geneNames, cellNames))
cellAnnots <- as.data.frame(cbind(CellID=cellNames, 
                                  cellType=sample(size = length(cellNames), 
                                                  replace = TRUE,
                                                  x = c("A", "B", "C", "D"),
                                                  prob = c(0.1, 0.4, 0.3, 0.2))))
table(cellAnnots$cellType)
profile_matrix <- create_profile_matrix(mtx = mtx,    
                                        cellAnnots = cellAnnots, 
                                        cellTypeCol = "cellType",
                                        cellNameCol = "CellID",
                                        minGenes = 10,
                                        scalingFactor = 1)
head(profile_matrix)
}
