# Return the mean squared error between the observed counts and the predicted ones for all the configurations considered 
# during cross-validation. This function expects an input object as the one generated by the function nmf.LassoCV.
#
# @examples
# data(cv_example)
# res = as.mean.squared.error(cv_example)
#
# @title as.mean.squared.error
# @param nmf.LassoCV.result results of cross validation into an object as the one generated by the function nmf.LassoCV
# @return A list with distributions and median values of the mean squared error values computed between the observed counts 
# and the predicted ones at each iteration of cross validation
# @export as.mean.squared.error
#
#"as.mean.squared.error" <- function( nmf.LassoCV.result ) {
#
#    mean_squared_error_distribution <- array(list(),dim(nmf.LassoCV.result[[1]][["mean_squared_error"]][[1]]))
#    rownames(mean_squared_error_distribution) <- rownames(nmf.LassoCV.result[[1]][["mean_squared_error"]][[1]])
#    colnames(mean_squared_error_distribution) <- colnames(nmf.LassoCV.result[[1]][["mean_squared_error"]][[1]])
#
#    for(i in 1:length(nmf.LassoCV.result)) {
#        curr_mse <- nmf.LassoCV.result[[i]][["mean_squared_error"]]
#        curr_mse_best <- curr_mse[[length(curr_mse)]]
#        invalid <- which(is.na(curr_mse_best),arr.ind=TRUE)
#        if(dim(invalid)[1]>0) {
#            for(j in 1:dim(invalid)[1]) {
#                curr_conf_k <- invalid[j,"row"]
#                curr_conf_l <- invalid[j,"col"]
#                for(j in 1:(length(curr_mse)-1)) {
#                    if(!is.na(curr_mse[[j]][curr_conf_k,curr_conf_l])) {
#                        curr_mse_best[curr_conf_k,curr_conf_l] <- curr_mse[[j]][curr_conf_k,curr_conf_l]
#                    }
#                }
#            }
#        }
#        for(a in 1:dim(mean_squared_error_distribution)[1]) {
#            for(b in 1:dim(mean_squared_error_distribution)[2]) {
#                mean_squared_error_distribution[[a,b]] <- c(unlist(mean_squared_error_distribution[[a,b]]),curr_mse_best[a,b])
#            }
#        }
#    }
#    
#    mean_squared_error_median <- array(NA,dim(nmf.LassoCV.result[[1]][["mean_squared_error"]][[1]]))
#    rownames(mean_squared_error_median) <- rownames(nmf.LassoCV.result[[1]][["mean_squared_error"]][[1]])
#    colnames(mean_squared_error_median) <- colnames(nmf.LassoCV.result[[1]][["mean_squared_error"]][[1]])
#    for(a in 1:dim(mean_squared_error_distribution)[1]) {
#        for(b in 1:dim(mean_squared_error_distribution)[2]) {
#            mean_squared_error_median[a,b] <- median(mean_squared_error_distribution[[a,b]],na.rm=TRUE)
#        }
#    }
#    
#    mean_squared_error_results <- list(distribution=mean_squared_error_distribution,median=mean_squared_error_median)
#
#    return(mean_squared_error_results)
#    
#}
#
# Return the discovered alpha values for a given configuration from an input object as the one generated by the function evaluate.lambda.range.
#
# @examples
# data(lambda_range_example)
# res = as.alpha.in.range(lambda_range_example,lambda_value=0.10)
#
# @title as.alpha.in.range
# @param lambda.range.result discovered signatures into an object as the one generated by the function evaluate.lambda.range
# @param lambda_value value of LASSO used for the estimation whose configuration has to be returned
# @return A matrix with alpha values
# @export as.alpha.in.range
#
#"as.alpha.in.range" <- function( lambda.range.result, lambda_value = 0.20 ) {
#
#    nmf.LassoK.result <- lambda.range.result[[1,paste0(as.character(lambda_value),"_lambda")]]
#    return(nmf.LassoK.result$alpha)
#    
#}
#
# Return the discovered signatures (beta values) for a given configuration from an input object as the one generated by the function evaluate.lambda.range.
#
# @examples
# data(lambda_range_example)
# res = as.beta.in.range(lambda_range_example,lambda_value=0.10)
#
# @title as.beta.in.range
# @param lambda.range.result discovered signatures into an object as the one generated by the function evaluate.lambda.range
# @param lambda_value value of LASSO used for the estimation whose configuration has to be returned
# @return A matrix with beta values
# @export as.beta.in.range
#
#"as.beta.in.range" <- function( lambda.range.result, lambda_value = 0.20 ) {
#
#    nmf.LassoK.result <- lambda.range.result[[1,paste0(as.character(lambda_value),"_lambda")]]
#    return(nmf.LassoK.result$beta)
#    
#}
#
# Return the initial values of beta used for the estimation of the signatures for a given configuration from an input object as the one generated by the 
# function evaluate.lambda.range.
#
# @examples
# data(lambda_range_example)
# res = as.starting.beta.in.range(lambda_range_example,lambda_value=0.10)
#
# @title as.starting.beta.in.range
# @param lambda.range.result discovered signatures into an object as the one generated by the function nmf.LassoK
# @param lambda_value value of LASSO used for the estimation whose configuration has to be returned
# @return A matrix with the initial values of beta used for the estimation of the signatures
# @export as.starting.beta.in.range
#
#"as.starting.beta.in.range" <- function( lambda.range.result, lambda_value = 0.20 ) {
#
#    nmf.LassoK.result <- lambda.range.result[[1,paste0(as.character(lambda_value),"_lambda")]]
#    return(nmf.LassoK.result$starting_beta)
#    
#}
#
# Return the log-likelihood values for a given configuration for each iteration during the estimation of the signatures from an input object as the one 
# generated by the function evaluate.lambda.range.
#
# @examples
# data(lambda_range_example)
# res = as.loglik.progression.in.range(lambda_range_example,lambda_value=0.10)
#
# @title as.loglik.progression.in.range
# @param lambda.range.result discovered signatures into an object as the one generated by the function evaluate.lambda.range
# @param lambda_value value of LASSO used for the estimation whose configuration has to be returned
# @return A vector with log-likelihood values for each iteration during the estimation of the signatures
# @export as.loglik.progression.in.range
#
#"as.loglik.progression.in.range" <- function( lambda.range.result, lambda_value = 0.20 ) {
#
#    nmf.LassoK.result <- lambda.range.result[[1,paste0(as.character(lambda_value),"_lambda")]]
#    return(nmf.LassoK.result$loglik_progression)
#    
#}
#
# Return the discovered alpha values from an input object as the one generated by the function nmf.LassoK.
#
# @examples
# data(nmf_LassoK_example)
# res = as.alpha(nmf_LassoK_example)
#
# @title as.alpha
# @param nmf.LassoK.result discovered signatures into an object as the one generated by the function nmf.LassoK
# @return A matrix with alpha values
# @export as.alpha
#
#"as.alpha" <- function( nmf.LassoK.result ) {
#    
#    return(nmf.LassoK.result$alpha)
#    
#}
#
# Return the discovered signatures (beta values) from an input object as the one generated by the function nmf.LassoK.
#
# @examples
# data(nmf_LassoK_example)
# res = as.beta(nmf_LassoK_example)
#
# @title as.beta
# @param nmf.LassoK.result discovered signatures into an object as the one generated by the function nmf.LassoK
# @return A matrix with beta values
# @export as.beta
#
#"as.beta" <- function( nmf.LassoK.result ) {
#    
#    return(nmf.LassoK.result$beta)
#    
#}
#
# Return the initial values of beta used for the estimation of the signatures from an input object as the one generated by the function nmf.LassoK.
#
# @examples
# data(nmf_LassoK_example)
# res = as.starting.beta(nmf_LassoK_example)
#
# @title as.starting.beta
# @param nmf.LassoK.result discovered signatures into an object as the one generated by the function nmf.LassoK
# @return A matrix with the initial values of beta used for the estimation of the signatures
# @export as.starting.beta
#
#"as.starting.beta" <- function( nmf.LassoK.result ) {
#    
#    return(nmf.LassoK.result$starting_beta)
#    
#}
#
# Return the log-likelihood values for each iteration during the estimation of the signatures from an input object as the one generated by 
# the function nmf.LassoK.
#
# @examples
# data(nmf_LassoK_example)
# res = as.loglik.progression(nmf_LassoK_example)
#
# @title as.loglik.progression
# @param nmf.LassoK.result discovered signatures into an object as the one generated by the function nmf.LassoK
# @return A vector with log-likelihood values for each iteration during the estimation of the signatures
# @export as.loglik.progression
#
#"as.loglik.progression" <- function( nmf.LassoK.result ) {
#    
#    return(nmf.LassoK.result$loglik_progression)
#    
#}
