% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygons.R
\name{readPolygonsCosmx}
\alias{readPolygonsCosmx}
\title{readPolygonsCosmx}
\usage{
readPolygonsCosmx(
  polygonsFile,
  type = c("csv", "parquet"),
  x = "x_global_px",
  y = "y_global_px",
  xloc = "x_local_px",
  yloc = "y_local_px",
  keepMultiPol = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{polygonsFile}{A character string specifying the file path to the
polygon data.}

\item{type}{A character string specifying the file type ("csv" or "parquet").}

\item{x}{A character string specifying the x-coordinate column.}

\item{y}{A character string specifying the y-coordinate column.}

\item{xloc}{A character string specifying the local x-coordinate column.}

\item{yloc}{A character string specifying the local y-coordinate column.}

\item{keepMultiPol}{A logical value indicating whether to keep multipolygons.}

\item{verbose}{A logical value indicating whether to print additional
information.}
}
\value{
An `sf` object containing the CosMx polygon data.
}
\description{
This function reads polygon data specific to CosMx technology.
}
\examples{
example(readCosmxSPE)
polygons <- readPolygonsCosmx(metadata(spe)$polygons)
polygons
}
