% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{trainModel}
\alias{trainModel}
\title{trainModel}
\usage{
trainModel(modelMatrix, trainDF)
}
\arguments{
\item{modelMatrix}{a matrix describing the model variables, tipically created
with `getModelFormula` and `model.matrix` functions.}

\item{trainDF}{\[data.frame\]
A data frame containing at least the response column
\code{qscore_train}, coded as 0/1.}
}
\value{
A \code{\link[glmnet]{glmnet}} model object fitted with
\code{family="binomial"}, \code{alpha=0} (ridge), and a sequence of
\eqn{\lambda} values.
}
\description{
Fit a Ridge Logistic Regression Model

\code{trainModel} fits an L2-regularized (ridge) logistic regression
using \pkg{glmnet}, given a design matrix and a training data frame.
}
\examples{
example(computeTrainDF)
model_formula <- getModelFormula(metadata(spe)$technology)
model_matrix <- model.matrix(as.formula(model_formula), data=df_train)
fit <- trainModel(model_matrix, df_train)
coef(fit, s = 0.01)

}
