% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialQCPlots.R
\name{qcFlagPlots}
\alias{qcFlagPlots}
\title{qcFlagPlots}
\usage{
qcFlagPlots(
  spe,
  fov = unique(spe$fov),
  theme = c("light", "dark"),
  custom = FALSE
)
}
\arguments{
\item{spe}{A `SpatialExperiment` object containing spatial transcriptomics
data.}

\item{fov}{An integer or numeric vector specifying the FOVs to be plotted
Must match values in the `fov` column of `colData(spe)`.}

\item{theme}{A character string among "light" or "dark".}

\item{custom}{A boolean value. If TRUE, custom polygons derived metrics will
be used.}
}
\value{
A panel with multiple plots showing flagged cells for different
variables.
}
\description{
Plots the flagged cells identified with first filter, based on control count
on total count ratio, area in um and DAPI signal.

This function generates a plot that shows selected (FOVs)
within a `SpatialExperiment` object, with cells flagged in different colors
over a light or dark layout chosen by the user.
}
\examples{

example(readAndAddPolygonsToSPE)
spe <- spatialPerCellQC(spe)
spe <- computeThresholdFlags(spe)
p <- qcFlagPlots(spe, fov=16, theme="dark")
print(p)
}
