% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{computeTrainDF}
\alias{computeTrainDF}
\title{computeTrainDF}
\usage{
computeTrainDF(spe, verbose = FALSE)
}
\arguments{
\item{spe}{\linkS4class{SpatialExperiment}
A SpatialExperiment containing at least:
\itemize{
  \item assay(s) with nonzero \code{total} counts,
  \item \code{colData(spe)} columns including \code{log2CountArea},
  \code{dist_border}, etc.,
  \item \code{metadata(spe)$technology} indicating the platform.
}}

\item{verbose}{\[logical(1)\] (default \code{FALSE})
If \code{TRUE}, prints the number of “bad” and “good” cells selected.}
}
\value{
A \code{data.frame} with one row per cell, including:
\itemize{
  \item \code{qscore_train} (0/1) indicating “bad” vs “good”,
  \item relevant \code{colData} columns used for modeling.
}
}
\description{
Build a Balanced Training Data Frame from a SpatialExperiment

\code{computeTrainDF} takes a \linkS4class{SpatialExperiment} object,
flags spatial outliers on “log2CountArea”, then assembles a
balanced training set of “good” vs “bad” cells for subsequent model fitting.
}
\details{
Internally the function:
\enumerate{
   \item Filters out zero-count cells,
   \item Calls \code{computeSpatialOutlier()} on “log2CountArea” to get
   fences,
   \item Labels cells as “LOW”/“HIGH” outliers or “NO”,
   \item Delegates to either \code{.computeCosmxTrainSet()} or
   \code{.computeXenMerTrainSet()} based on \code{metadata(spe)$technology},
   \item Deduplicates and down-samples “good” cells to match the number of
   “bad” cells.
}
}
\examples{
example(spatialPerCellQC)
df_train <- computeTrainDF(spe, verbose = TRUE)
table(df_train$qscore_train)

}
