% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{computeLambda}
\alias{computeLambda}
\title{computeLambda}
\usage{
computeLambda(technology, trainDF)
}
\arguments{
\item{technology}{\[character\]
The name of the experimental technology. Passed to
\code{getModelFormula()} to retrieve the corresponding model formula.}

\item{trainDF}{\[data.frame\]
A data frame for training that must include:
\describe{
  \item{Predictor columns}{All columns referenced in the formula returned
  by \code{getModelFormula()}.}
  \item{\code{qscore_train}}{A binary (0/1) response vector to be modeled.}
}}
}
\value{
\[numeric\]
  The value of \eqn{\lambda} (i.e., \code{lambda.min}) from
  \code{\link[glmnet]{cv.glmnet}} that minimizes the cross-validation error.
}
\description{
Compute Optimal Ridge Regularization Parameter \eqn{\lambda} via
Cross-Validation

\code{computeLambda} performs ridge (L2) logistic regression with
cross-validation to identify the optimal regularization parameter
\eqn{\lambda} for a binary response.
}
\details{
Internally, the function:
\enumerate{
  \item Calls \code{getModelFormula(technology)} to obtain a model formula
  as text,
  \item Constructs the design matrix via \code{model.matrix()},
  \item Runs ridge logistic regression cross-validation using
        \code{\link[glmnet]{cv.glmnet}} with \code{alpha = 0},
  \item Extracts and returns \code{ridge_cv$lambda.min}.
}
}
\examples{
example(spatialPerCellQC)
withr::with_seed(1998, trainDF <- computeTrainDF(spe))
best_lambda <- computeLambda(metadata(spe)$technology, trainDF)
print(best_lambda)

}
\seealso{
\code{\link[glmnet]{cv.glmnet}}
}
