% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization_correction.R
\name{performCombinedNormalization}
\alias{performCombinedNormalization}
\title{Perform Combined Normalization on MultiAssayExperiment Data}
\usage{
performCombinedNormalization(maeData)
}
\arguments{
\item{maeData}{A \code{MultiAssayExperiment} object containing proteome and
phosphoproteome data.}
}
\value{
A numeric \code{matrix} with normalized and log2-transformed data.
}
\description{
\code{performCombinedNormalization} performs combined normalization on
proteome and phosphoproteome data from a \code{MultiAssayExperiment} object.
}
\details{
The function performs the following steps:
\enumerate{
  \item Extracts the count matrices for Full Proteome (FP) samples.
  \item Combines the proteome and phosphoproteome data into a single matrix.
  \item Removes rows with all NA values.
  \item Performs median normalization and log2 transformation on the
  combined matrix.
}
}
\examples{
# Load multiAssayExperiment object
data("dia_example")
# Call the function
performCombinedNormalization(dia_example)

}
