% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinase_activity.R
\name{plotKinaseDE}
\alias{plotKinaseDE}
\title{Plot Kinase score for Differential Expression data}
\usage{
plotKinaseDE(scoreTab, nTop = 10, pCut = 0.05)
}
\arguments{
\item{scoreTab}{A \code{data frame} containing kinase scores with columns
source, score, and p_value.}

\item{nTop}{A \code{numeric} value specifying the number of top kinases to
plot for each direction. Default is 10.}

\item{pCut}{A \code{numeric} value specifying the p-value cutoff for
significance. Default is 0.05.}
}
\value{
A \code{ggplot2} object representing the bar plot of kinase score.
}
\description{
`plotKinaseDE` generates a \code{bar plot} of the top kinases associated
with the differentially expressed genes based on their scores.
}
\details{
The function performs the following steps:
\enumerate{
  \item Adds a column for significance based on the p-value cutoff.
  \item Adds a column for the sign of the score.
  \item Filters out kinases with a score of 0.
  \item Selects the top \code{nTop} kinases by absolute score for each sign
  of the score.
  \item Creates a bar plot with the selected kinases.
}
}
\examples{
# Example usage:
scoreTab <- data.frame(
 source = c("Kinase1", "Kinase2", "Kinase3", "Kinase4"),
 score = c(2.3, -1.5, 0, 3.1),
 p_value = c(0.01, 0.2, 0.05, 0.03)
)
plotKinaseDE(scoreTab, nTop = 3, pCut = 0.05)

}
