% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleR.R
\name{SingleR}
\alias{SingleR}
\title{Annotate scRNA-seq data}
\usage{
SingleR(
  test,
  ref,
  labels,
  method = NULL,
  clusters = NULL,
  genes = "de",
  sd.thresh = 1,
  de.method = "classic",
  de.n = NULL,
  de.args = list(),
  aggr.ref = FALSE,
  aggr.args = list(),
  recompute = TRUE,
  restrict = NULL,
  quantile = 0.8,
  fine.tune = TRUE,
  tune.thresh = 0.05,
  fine.tune.combined = fine.tune,
  prune = TRUE,
  assay.type.test = "logcounts",
  assay.type.ref = "logcounts",
  check.missing.test = FALSE,
  check.missing.ref = check.missing,
  check.missing = TRUE,
  num.threads = bpnworkers(BPPARAM),
  BNPARAM = NULL,
  BPPARAM = SerialParam()
)
}
\arguments{
\item{test}{A numeric matrix of single-cell expression values where rows are genes and columns are cells.
Alternatively, a \link[SummarizedExperiment]{SummarizedExperiment} object containing such a matrix.}

\item{ref}{A numeric matrix of (usually normalized and log-transformed) expression values from a reference dataset,
or a \link[SummarizedExperiment]{SummarizedExperiment} object containing such a matrix;
see \code{\link{trainSingleR}} for details.

Alternatively, a list or \link[S4Vectors]{List} of SummarizedExperiment objects or numeric matrices containing multiple references.
Row names may be different across entries but only the intersection will be used, see Details.}

\item{labels}{A character vector or factor of known labels for all samples in \code{ref}.

Alternatively, if \code{ref} is a list, \code{labels} should be a list of the same length.
Each element should contain a character vector or factor specifying the labels for the columns of the corresponding element of \code{ref}.}

\item{method}{Deprecated.}

\item{clusters}{A character vector or factor of cluster identities for each cell in \code{test}.
If set, annotation is performed on the aggregated cluster profiles, otherwise it defaults to per-cell annotation.}

\item{genes, sd.thresh, de.method, de.n, de.args}{Arguments controlling the choice of marker genes used for annotation, see \code{\link{trainSingleR}}.}

\item{aggr.ref, aggr.args}{Arguments controlling the aggregation of the references prior to annotation, see \code{\link{trainSingleR}}.}

\item{recompute}{Deprecated and ignored.}

\item{restrict}{A character vector of gene names to use for marker selection.
By default, all genes in \code{ref} are used.}

\item{quantile, fine.tune, tune.thresh, fine.tune.combined, prune}{Further arguments to pass to \code{\link{classifySingleR}}.}

\item{assay.type.test}{An integer scalar or string specifying the assay of \code{test} containing the relevant expression matrix,
if \code{test} is a \link[SummarizedExperiment]{SummarizedExperiment} object.}

\item{assay.type.ref}{An integer scalar or string specifying the assay of \code{ref} containing the relevant expression matrix,
if \code{ref} is a \link[SummarizedExperiment]{SummarizedExperiment} object (or is a list that contains one or more such objects).}

\item{check.missing.test}{Logical scalar indicating whether rows of \code{test} should be checked for missing values (and if found, removed).}

\item{check.missing.ref}{Logical scalar indicating whether rows of \code{ref} should be checked for missing values (and if found, removed).}

\item{check.missing}{Deprecated, use \code{check.missing.test} and \code{check.missing.ref} instead.}

\item{num.threads}{Integer scalar specifying the number of threads to use for index building and classification.}

\item{BNPARAM}{Deprecated and ignored.}

\item{BPPARAM}{A \link[BiocParallel]{BiocParallelParam} object specifying how parallelization should be performed in other steps,
see \code{?\link{trainSingleR}} and \code{?\link{classifySingleR}} for more details.}
}
\value{
A \link[S4Vectors]{DataFrame} is returned containing the annotation statistics for each cell (one cell per row).
This is identical to the output of \code{\link{classifySingleR}}.
}
\description{
Returns the best annotation for each cell in a test dataset,
given a labelled reference dataset in the same feature space.
}
\details{
This function is just a convenient wrapper around \code{\link{trainSingleR}} and \code{\link{classifySingleR}}.
The function will automatically restrict the analysis to the intersection of the genes in both \code{ref} and \code{test}.
If this intersection is empty (e.g., because the two datasets use different gene annotations), an error will be raised.

If \code{clusters} is specified, per-cell profiles are summed to obtain per-cluster profiles.
Annotation is then performed by running \code{\link{classifySingleR}} on these profiles.
This yields a DataFrame with one row per level of \code{clusters}.

The default settings of this function are based on the assumption that \code{ref} contains or bulk data.
If it contains single-cell data, this usually requires a different \code{de.method} choice.
Read the Note in \code{?\link{trainSingleR}} for more details.
}
\examples{
# Mocking up data with log-normalized expression values:
ref <- .mockRefData()
test <- .mockTestData(ref)

ref <- scuttle::logNormCounts(ref)
test <- scuttle::logNormCounts(test)

# Running the classification with different options:
pred <- SingleR(test, ref, labels=ref$label)
table(predicted=pred$labels, truth=test$label)

k.out<- kmeans(t(assay(test, "logcounts")), center=5) # mock up a clustering
pred2 <- SingleR(test, ref, labels=ref$label, clusters=k.out$cluster) 
table(predicted=pred2$labels, cluster=rownames(pred2))

}
\references{
Aran D, Looney AP, Liu L et al. (2019).
Reference-based analysis of lung single-cell sequencing reveals a transitional profibrotic macrophage.
\emph{Nat. Immunology} 20, 163–172.
}
\author{
Aaron Lun, based on code by Dvir Aran.
}
