% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{dataset_sfaira}
\alias{dataset_sfaira}
\title{Build \link[SummarizedExperiment]{SummarizedExperiment} using a single sfaira entry ID}
\usage{
dataset_sfaira(
  sfaira_id,
  sfaira_setup,
  name = "SimBu_dataset",
  spike_in_col = NULL,
  additional_cols = NULL,
  force = FALSE,
  filter_genes = TRUE,
  variance_cutoff = 0,
  type_abundance_cutoff = 0,
  scale_tpm = TRUE
)
}
\arguments{
\item{sfaira_id}{(mandatory) ID of a sfaira dataset}

\item{sfaira_setup}{(mandatory) the sfaira setup; given by \code{\link{setup_sfaira}}}

\item{name}{name of the dataset; will be used for new unique IDs of cells}

\item{spike_in_col}{which column in annotation contains information on spike_in counts, which can be used to re-scale counts}

\item{additional_cols}{list of column names in annotation, that should be stored as well in dataset object}

\item{force}{boolean, if TRUE, datasets without annotation will be downloaded, FALSE otherwise (default)}

\item{filter_genes}{boolean, if TRUE, removes all genes with 0 expression over all samples & genes with variance below \code{variance_cutoff}}

\item{variance_cutoff}{numeric, is only applied if \code{filter_genes} is TRUE: removes all genes with variance below the chosen cutoff}

\item{type_abundance_cutoff}{numeric, remove all cells, whose cell-type appears less then the given value. This removes low abundant cell-types}

\item{scale_tpm}{boolean, if TRUE (default) the cells in tpm_matrix will be scaled to sum up to 1e6}
}
\value{
dataset object
}
\description{
Build \link[SummarizedExperiment]{SummarizedExperiment} using a single sfaira entry ID
}
\examples{
\donttest{
setup_list <- SimBu::setup_sfaira(tempdir())
ds <- SimBu::dataset_sfaira(
  sfaira_id = "homosapiens_lungparenchyma_2019_10x3v2_madissoon_001_10.1186/s13059-019-1906-x",
  sfaira_setup = setup_list,
  name = "test_dataset"
)
}
}
