% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcf2mut_cat.R
\name{vcf2mut_cat}
\alias{vcf2mut_cat}
\title{Derive the mutational catalogue from a vcf}
\usage{
vcf2mut_cat(vcf, genome, name = NULL, seqs = NULL)
}
\arguments{
\item{vcf}{*.vcf file or a vcf object containing variant calling data for one
patient}

\item{genome}{a BSgenome object corresponding to the genome the variants were
called on}

\item{name}{optional, a sample name}

\item{seqs}{optional, a character vector containing the names of the 
sequences that are to be included in the mutational profile. If none is given
everything will we included}
}
\value{
mutational catalogue (matrix) of a patient containing SNV absolute 
counts (in the 96 trinucleotide context)
format: 1 by 96
}
\description{
Creates a matrix containing the mutational catalogue from a vcf file or 
object. The result can be input to the analysis functions of this package.
}
\note{
The execution can take some time, depending on the size of the vcf
}
\examples{
\dontrun{
vcf2mut_cat('test.vcf', BSgenome.Hsapiens.UCSC.hg19::BSgenome.Hsapiens.UCSC.hg19)
}
}
