% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/developerAPIS.R
\name{getLastIndex}
\alias{getLastIndex}
\alias{allocateSharedMemory}
\alias{mapSharedMemory}
\alias{unmapSharedMemory}
\alias{freeSharedMemory}
\alias{hasSharedMemory}
\alias{getSharedMemorySize}
\alias{initialSharedObjectPackageData}
\alias{releaseSharedObjectPackageData}
\title{Functions to manipulate shared memory}
\usage{
getLastIndex()

allocateSharedMemory(size, name = "")

mapSharedMemory(id)

unmapSharedMemory(id)

freeSharedMemory(id)

hasSharedMemory(id)

getSharedMemorySize(id)

initialSharedObjectPackageData()

releaseSharedObjectPackageData()
}
\arguments{
\item{size}{The size of the shared memory that you want to allocate}

\item{name, id}{The name of the shared memory}
}
\value{
\code{getLastIndex}: An interger ID served as a hint of the last created shared memory ID.

\code{allocateSharedMemory}: character ID(s) that can be used to find the shared memory

\code{mapSharedMemory}: External pointer(s) to the shared memory

\code{unmapSharedMemory}: No return value

\code{freeSharedMemory}: No return value

\code{hasSharedMemory}: Logical value(s) indicating whether the shared memory exist

\code{getSharedMemorySize}: A numeric value
}
\description{
These functions are designed for package developers only, they can
allocate, open, close and destroy shared memory without touching
C++ code. Normal users should not use these functions unless
dealing with memory leaking
}
\details{
\strong{Quick explanation}

\code{getLastIndex}: the ID of the last created shared memory.

\code{allocateSharedMemory}: allocate a shared memory of a given size,
the memory ID is returned by the function

\code{mapSharedMemory}: map the shared memory to the current process memory space

\code{unmapSharedMemory}: unmap the shared memory(without destroying it)

\code{freeSharedMemory}: free the shared memory. This function will only unmap the
shared memory on Windows.

\code{hasSharedMemory}: whether the memory exist?

\code{getSharedMemorySize}: get the actual size of the shared memory, it may be larger than the
size that you required.

\strong{Details}

A complete lifecycle of a shared memory involves four steps:
allocating, mapping, unmapping and freeing the shared memory.

The shared memory can be created by \code{allocateSharedMemory}.
The function \code{allocateSharedMemory} will return the ID of the shared memory.
After creating the shared memory, it can be mapped to the current process by
\code{mapSharedMemory}. The return value is an external pointer to the shared memory.
Once the shared memory is no longer needed, it can be unmapped and destroyed by
\code{unmapSharedMemory} and \code{freeSharedMemory} respectively.
}
\examples{
size <- 10L
## unnamed shared memory
id <- allocateSharedMemory(size)
hasSharedMemory(id)
ptr <- mapSharedMemory(id)
ptr
getSharedMemorySize(id)
unmapSharedMemory(id)
freeSharedMemory(id)
hasSharedMemory(id)

## named shared memory
name <- "SharedObjectExample"
if(!hasSharedMemory(name)){
    allocateSharedMemory(size, name = name)
    hasSharedMemory(name)
    ptr <- mapSharedMemory(name)
    ptr
    getSharedMemorySize(name)
    unmapSharedMemory(name)
    freeSharedMemory(name)
    hasSharedMemory(name)
}
}
\seealso{
\code{\link{listSharedObjects}}
}
