\name{seqTranspose}
\alias{seqTranspose}
\title{Transpose Data Array}
\description{
    Transpose data array or matrix for possibly higher-speed access.
}
\usage{
seqTranspose(gdsfile, var.name, compress=NULL, digest=TRUE, verbose=TRUE)
}
\arguments{
    \item{gdsfile}{a \code{\link{SeqVarGDSClass}} object}
    \item{var.name}{the variable name with '/' as a separator}
    \item{compress}{the compression option used in
        \code{\link{add.gdsn}}; or determine automatically
        if \code{NULL}}
    \item{digest}{a logical value (TRUE/FALSE) or a character ("md5", "sha1",
        "sha256", "sha384" or "sha512"); add md5 hash codes to the GDS file
        if TRUE or a digest algorithm is specified}
    \item{verbose}{if \code{TRUE}, show information}
}
\value{
    None.
}
\details{
    It is designed for possibly higher-speed access. More details will be
provided in the future version.
}

\author{Xiuwen Zheng}
\seealso{
    \code{\link{seqGetData}}, \code{\link{seqApply}}
}

\examples{
# the VCF file
(vcf.fn <- seqExampleFileName("vcf"))

# convert
seqVCF2GDS(vcf.fn, "tmp.gds", storage.option="ZIP_RA")

# list the structure of GDS variables
f <- seqOpen("tmp.gds", FALSE)
f

seqTranspose(f, "genotype/data")
f

# the original array
index.gdsn(f, "genotype/data")
# the transposed array
index.gdsn(f, "genotype/~data")

# close
seqClose(f)

# delete the temporary file
unlink("tmp.gds")
}

\keyword{gds}
\keyword{sequencing}
\keyword{genetics}
