% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post.processing.R
\name{TsneVis}
\alias{TsneVis}
\title{Plot a tSNE map colored by a marker of interest}
\usage{
TsneVis(final, marker, label = marker)
}
\arguments{
\item{final}{The tibble of cells by features outputted from the
post.processing function. These features encompass both regular markers
from the original data and the KNN statistics processed markers}

\item{marker}{String that matches the marker name in the final data object
exactly.}

\item{label}{a string that indicates the name of the color label in the
ensuing plot. Set to the marker string as default.}
}
\value{
A plot of bh-SNE1 x bh-SNE2 colored by the specified marker.
}
\description{
Wrapper for ggplot2 based plotting of a tSNE map to color
by markers from the post-processed file if tSNE was set to TRUE in
the post-processing function.
}
\examples{
TsneVis(wand.final, "pSTAT5(Nd150)Di.IL7.change", "pSTAT5 change")
}
