% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post.processing.R
\name{SubsampleAndTsne}
\alias{SubsampleAndTsne}
\title{Subsample data and run tSNE}
\usage{
SubsampleAndTsne(dat, input, numcells)
}
\arguments{
\item{dat}{tibble of original input data, and scone-based additions.}

\item{input}{the markers used in the original knn computation, which are
typically surface markers}

\item{numcells}{the number of cells to be downsampled to}
}
\value{
a subsampled tibble that contains tSNE values
}
\description{
A wrapper for Rtsne that takes final SCONE output, and runs
tSNE on it after subsampling. This is specifically for SCONE runs that
contain large numbers of cells that tSNE would either be too time-consuming
or messy for. Regarding the latter, tSNE typically appears less clean
in the range of 10^5 cells
}
\examples{
SubsampleAndTsne(wand.combined, input.markers, 500)
}
