% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn.and.statistics.R
\name{RunStatistics}
\alias{RunStatistics}
\title{Performs a series of statistical tests on the batch of cells
of interest.}
\usage{
RunStatistics(basal, stim, fold = "median", stat.test = "mwu", stim.name)
}
\arguments{
\item{basal}{tibble of cells corresponding to the unstimulated condition}

\item{stim}{a tibble of cells corresponding to the stimulated condition}

\item{fold}{a string that specifies the use of "median" or "mean" when
calculating fold change}

\item{stat.test}{a string that specifies Mann-Whitney U test (mwu) or T test
(t) for q value calculation}

\item{stim.name}{a string corresponding to the name of the stim being tested
compared to basal}
}
\value{
result: a named vector corresponding to the results of the
"fold change" and mann-whitney u test
}
\description{
This function performs the statistics across the nearest
neighborhoods, and is one of the main workhorses within the scone.values
function
}
