% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.files.R
\name{QuantNormalizeElements}
\alias{QuantNormalizeElements}
\title{Takes a list of tibbles as input, and performs per-column
quantile normalization, then outputs the quantile normalized list}
\usage{
QuantNormalizeElements(dat.list)
}
\arguments{
\item{dat.list}{a list of tibbles}
}
\value{
the per-column quantile normalized list
}
\description{
This function performs per-marker quantile normalization
on multiple data tibbles. The normalization occurrs marker by marker.
The user assumes that the markers are distributed equally across tibbles,
as quantile normalization forces these marker distributions to be the same
per file
}
\examples{
basal <- wand.combined[wand.combined$condition == "basal",][,1:10]
il7 <- wand.combined[wand.combined$condition == "IL7",][,1:10]
QuantNormalizeElements(list(basal, il7))
}
