% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_all_peptides.R
\name{filter_all_peptides}
\alias{filter_all_peptides}
\title{Select all proteins that are supported by peptides.}
\usage{
filter_all_peptides(data)
}
\arguments{
\item{data}{A data frame containing SWATH data.}
}
\value{
Returns a data frame with the data from both proteotypic and
  non-proteotypic peptides.
}
\description{
This function can be used as opposed to the function 
"filter_proteotypic_peptides()". This function counts all proteins (including
proteins supported by non proteo-typic (i.e. shared) peptides). 
All peptides (incl. non proteotypic peptides are selected. 
For the proteins supported by proteotypic peptide the "1/" in front
of the identifier is removed to facilitate further data processing. 
The protein identifier of shared peptides needs to be separated by a slash "/".
}
\examples{
{
 data("OpenSWATH_data", package="SWATH2stats")
 data("Study_design", package="SWATH2stats")
 data <- sample_annotation(OpenSWATH_data, Study_design)
 data.filtered.decoy <- filter_mscore(data, 0.01)
 data.all <- filter_all_peptides(data.filtered.decoy)
 }
}
\author{
Peter Blattmann
}
