% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_on_max_peptides.R
\name{filter_on_max_peptides}
\alias{filter_on_max_peptides}
\title{Filter only for the highest intense peptides}
\usage{
filter_on_max_peptides(
  data,
  n_peptides,
  protein_col = "ProteinName",
  peptide_col = c("Peptide.Sequence", "FullPeptideName"),
  rm.decoy = TRUE
)
}
\arguments{
\item{data}{A data frame containing SWATH data with the column names:
ProteinNames, PeptideSequence, PrecursorCharge, Intensity.}

\item{n_peptides}{Maximum number of highest intense peptides to filter the
data on.}

\item{protein_col}{Column with protein identifiers. Default: ProteinName}

\item{peptide_col}{Column with peptide identifiers. Default: Peptide.Sequence or FullPeptideName}

\item{rm.decoy}{Option to remove the decoys during filtering.}
}
\value{
Returns a data frame of the filtered data.
}
\description{
In order to reduce the data, the data is filtered only for the proteins with
the highest intensity peptides.
}
\examples{
{
 data("OpenSWATH_data", package="SWATH2stats")
 data("Study_design", package="SWATH2stats")
 data <- sample_annotation(OpenSWATH_data, Study_design)
 data.filtered <- filter_mscore_freqobs(data, 0.01,0.8)
 data.max <- filter_on_max_peptides(data.filtered, 5)
 }
}
\author{
Peter Blattmann
}
