% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_protein_ids.R
\name{load_mart}
\alias{load_mart}
\title{Establish connection to biomaRt database}
\usage{
load_mart(species, ensembl.path = "www.ensembl.org", mart, verbose = FALSE)
}
\arguments{
\item{species}{The species of the protein identifiers in the term used by
biomaRt (e.g. "hsapiens_gene_ensembl", "mmusculus_gene_ensembl",
"drerio_gene_ensembl", etc.)}

\item{ensembl.path}{Ensembl host to connect to. Default: www.ensembl.org}

\item{mart}{The type of mart (e.g. "ENSEMBL_MART_ENSEMBL", etc.)}

\item{verbose}{print a summary of the ensembl connection.}
}
\value{
Connection for performing biomart queries.
}
\description{
This function establishes a connection to a biomart database.
}
\examples{
{
 data_table <- data.frame(Protein = c("Q01581", "P49327", "2/P63261/P60709"),
                          Abundance = c(100, 3390, 43423))
 mart <- convert_protein_ids(data_table)
 }
}
\author{
Peter Blattmann
}
