% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert4MSstats.R
\name{convert4MSstats}
\alias{convert4MSstats}
\title{Get data ready for use by MSstats.}
\usage{
convert4MSstats(
  data,
  replace_values = TRUE,
  replace_colnames = TRUE,
  replace_unimod = TRUE
)
}
\arguments{
\item{data}{A data frame containing SWATH data.}

\item{replace_values}{Option to indicate if negative and 0 values should be replaced with NA.}

\item{replace_colnames}{Option to indicate if column names should be renamed
and columns reduced to the necessary columns for MSstats.}

\item{replace_unimod}{Option to indicate if Unimod Identifier should be
replaced from ":" to "_".}
}
\value{
Returns a data frame in the appropriate format for MSstats.
}
\description{
Though SWATH2stats uses very similar format as MSstats, some coercion is 
required to convert the data into the format for MSstats.
}
\details{
This functions selects the columns necessary for MSstats and renames them if
necessary.

The necessary columns are selected and three columns renamed:
FullPeptideName -> PeptideSequence
Charge -> PrecursorCharge
filename -> File
}
\examples{
 data("OpenSWATH_data", package="SWATH2stats")
 data("Study_design", package="SWATH2stats")
 data <- sample_annotation(OpenSWATH_data, Study_design)
 data.filtered.decoy <- filter_mscore(data, 0.01)
 raw <- disaggregate(data.filtered.decoy)
 data.mapDIA <- convert4MSstats(raw)
}
\references{
Choi M, Chang CY, Clough T, Broudy D, Killeen T, MacLean B, Vitek
  O. MSstats: an R package for statistical analysis of quantitative mass
  spectrometry-based proteomic experiments.Bioinformatics. 2014 Sep
  1;30(17):2524-6. doi: 10.1093/bioinformatics/btu305.
}
\author{
Peter Blattmann
}
