% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_decoy_rate.R
\name{assess_decoy_rate}
\alias{assess_decoy_rate}
\title{Assess decoy rate in data}
\usage{
assess_decoy_rate(data, column = "FullPeptideName", column_decoy = "decoy")
}
\arguments{
\item{data}{A data frame that contains at least a column named 
"FullPeptideName" and "decoy".}

\item{column}{The column name of the Peptide identifier. 
Default: FullPeptideName.}

\item{column_decoy}{The column name of the decoy column. Default: decoy.}
}
\value{
Message detailing the number of decoys, non-decoys, and the ratio.
}
\description{
This function assesses the number of quantifications (typically peptides)
that are decoys (false-positive) versus true identifications.
}
\details{
A printout is generated to indicate the number of non-decoy, decoy peptides
and the rate of decoy vs non-decoy peptides. Unique peptides are counted, so
a precursor with different charge states is counted as one peptide. In the
column "decoy" the values need to be 1,0 or TRUE and FALSE.
}
\examples{
 data("OpenSWATH_data", package="SWATH2stats")
 data <- OpenSWATH_data
 assess_decoy_rate(data)
}
\author{
Peter Blattmann
}
