% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-svg.R
\name{runKldSVG}
\alias{runKldSVG}
\alias{runKldSVG,SingleCellExperiment-method}
\alias{runKldSVG,SingleCellExperiment}
\alias{runKldSVG,SVPExperiment-method}
\alias{runKldSVG,SVPExperiment}
\title{Detecting the spatially or single cell variable features with Kullback–Leibler divergence of
2D weighted kernel density estimation}
\usage{
runKldSVG(
  data,
  assay.type = "logcounts",
  reduction.used = NULL,
  sample_id = "all",
  grid.n = 100,
  permutation = 100,
  p.adjust.method = "BY",
  verbose = TRUE,
  action = c("add", "only", "get"),
  random.seed = 1024,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  ...
)

\S4method{runKldSVG}{SingleCellExperiment}(
  data,
  assay.type = "logcounts",
  reduction.used = NULL,
  sample_id = "all",
  grid.n = 100,
  permutation = 100,
  p.adjust.method = "BY",
  verbose = TRUE,
  action = c("add", "only", "get"),
  random.seed = 1024,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  ...
)

\S4method{runKldSVG}{SVPExperiment}(
  data,
  assay.type = "logcounts",
  reduction.used = NULL,
  sample_id = "all",
  grid.n = 100,
  permutation = 100,
  p.adjust.method = "BY",
  verbose = TRUE,
  action = c("add", "only", "get"),
  random.seed = 1024,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  ...
)
}
\arguments{
\item{data}{a \linkS4class{SingleCellExperiment} object with contains \code{UMAP} or \code{TSNE},
or a \linkS4class{SpatialExperiment} object, or a \linkS4class{SVPExperiment} object with specified
\code{gsvaexp} argument.}

\item{assay.type}{which expressed data to be pulled to run, default is \code{logcounts}.}

\item{reduction.used}{character used as spatial coordinates to calculate the neighbours weights,
default is \code{NULL}, the result of reduction can be specified, such as \code{UMAP}, \code{TSNE}, \code{PCA}.
If it is specified, the weight neighbours matrix will be calculated using the result of specified reduction.}

\item{sample_id}{character the sample(s) in the \linkS4class{SpatialExperiment} object whose cells/spots to use.
Can be \code{all} to compute metric for all samples; the metric is computed separately for each sample.
default is \code{"all"}.}

\item{grid.n}{numeric number of grid points in the two directions to estimate 2D weighted kernel
density, default is 100.}

\item{permutation}{numeric the number of permutation for each single feature to detect the
significantly spatially or single cell variable features, default is 100.}

\item{p.adjust.method}{character the method to adjust the pvalue of the result, default is \code{BY}.}

\item{verbose}{logical whether print the intermediate message when running the program, default is TRUE.}

\item{action}{character control the type of output, if \code{action='add'}, the result of identification
will add the original object, if \code{action = 'get'}, the result will return a \linkS4class{SimpleList},
if \code{action = 'only'}, the result will return a \linkS4class{DataFrame} by merging the result of all
sample, default is \code{add}.}

\item{random.seed}{numeric random seed number to repeatability, default is 1024.}

\item{gsvaexp}{which gene set variation experiment will be pulled to run, this only work when \code{data} is a
\linkS4class{SVPExperiment}, default is NULL.}

\item{gsvaexp.assay.type}{which assay data in the specified \code{gsvaexp} will be used to run, default is NULL.}

\item{...}{additional parameters}
}
\value{
a \linkS4class{SVPExperiment} or a \linkS4class{SingleCellExperiment}, see details.
}
\description{
To resolve the sparsity of single cell or spatial omics data, we use kernel function smoothing cell
density weighted by the gene expression in a low-dimensional space or physical space. This method had
reported that it can better represent the gene expression, it can also recover the signal from cells that
are more likely to express a gene based on their neighbouring cells (first reference). Next, we use
kullback-leibler divergence to detect the signal genes in a low-dimensional space (\code{UMAP} or \code{TSNE}
for single cell omics data) or a physical space (for spatial omics data). See details to learn more.
}
\details{
if input is a \linkS4class{SVPExperiment}, output will be also a \linkS4class{SVPExperiment}, the spatially variable gene sets
result is stored in \code{svDfs} of the specified \code{gsvaexp}, which is a \linkS4class{SingleCellExperiment}. If input is
a \linkS4class{SingleCellExperiment} (which is extracted from \linkS4class{SVPExperiment} using \code{gsvaExp()} function), output
will be also a \linkS4class{SingleCellExperiment}, the spatial variable gene sets result can be extracted using \code{svDf} function.
The result of \code{svDf} will return a matrix which has \code{sp.kld}, \code{boot.sp.kld.mean}, \code{boot.sp.kld.sd}, \code{pvalue},
\code{padj} and \code{rank}.
\itemize{
\item \code{sp.kld} which is logarithms of Kullback–Leibler divergence, larger value meaning the greater the difference from the
background distribution without spatial variability.
\item \code{boot.sp.kld.mean} which is mean of logarithms of Kullback–Leibler divergence based on the permutation of each features.
\item \code{boot.sp.kld.sd} which is standard deviation of logarithms of Kullback–Leibler divergence based on the permutation of
each features.
\item \code{pvalue} the pvalue is calculated using the real \code{sp.kld} and the permutation \code{boot.sp.kld.mean} and
\code{boot.sp.kld.sd} based on the normal distribution.
\item \code{padj} the adjusted pvalue based on the specified \code{p.adjust.method}, default is \code{BY}.
\item \code{rank} the order of significant spatial variable features based on \code{padj} and \code{sp.kld}.
}

The kernel density estimation for each features in each cells is done in the following way (first reference article):

\eqn{f_{h}(x) = 1/n \sum_{i=1}^n W_{i} * K_{h}(x - X_{i})}

Where \eqn{W_{i}} is the value of feature (such as gene expression or gene set score). \eqn{X_{i}} is the embeddings (two
dimension coordinates of \code{UMAP} or \code{TSNE} or the physical space for spatial omics data) of the cell \eqn{i}.
\eqn{h} is a smoothing parameter corresponding to the bandwidth matrix, default is the implementation of \code{ks} package.
\eqn{K(x)} is a gaussian kernel function. \eqn{x} is the a reference point in the embedding space defined by the grid size
used for the computation to weight the distances of nearby cells. \eqn{K_{h}(x—X_{i})}works as a weight for \eqn{W_{i}} to
smooth the feature value based on neighbouring cells at a \code{UMAP} or \code{TSNE} or physical space.

The Kullback-Leibler divergence for each features is calculated in the following way:

\eqn{D_{KL}(G) = \sum_{x \in X} P(x) * \log(P(x) / Q(x))}

Where \eqn{P(x)} is the kernel density value of a feature at the space \eqn{X}. and \eqn{Q(x)} is the kernel density value of no spatially
variability reference feature at the space \eqn{X}. The smaller kullback-leibler divergence (\eqn{D_{KL}(G)}) show that the distribution of
features is more like the no spatially variability reference feature at th space \eqn{X}. So we randomly shuffle the position of each feature
and calculate Kullback-Leibler divergence, next we use the normal distribution to calculate the pvalue with the actual Kullback-Leibler
divergence, and the average value and standard deviation value of random Kullback-Leibler divergence, since the random Kullback-Leibler
divergence for each feature is normally distributed in the following:

\eqn{X \sim \mathcal{N}(\mu,\,\sigma^{2})}

where \eqn{\mu} is the average value of random Kullback-Leibler divergence, and \eqn{\sigma} is standard deviation.
}
\examples{
# This example dataset is extracted from the
# result of runSGSA with gsvaExp(svpe).
data(hpda_spe_cell_dec)

hpda_spe_cell_dec <-
    hpda_spe_cell_dec |>
    runKldSVG(
      assay.type = 'affi.score'
    )

# The result can be extracted svDf()
hpda_spe_cell_dec |> svDf() |> data.frame() |> dplyr::arrange(rank)
# the Acinar cells, Cancer clone A, Cancer clone B etc have
# significant spatial variable.
# Then we can use pred.feature.mode to predict the activity
# mode in spatial domain.
}
\references{
\enumerate{
\item Jose Alquicira-Hernandez, Joseph E Powell, Nebulosa recovers single-cell gene expression signals by kernel density estimation.
Bioinformatics, 37, 2485–2487(2021), https://doi.org/10.1093/bioinformatics/btab003.
\item Vandenbon, A., Diez, D. A clustering-independent method for finding differentially expressed genes in single-cell transcriptome
data. Nat Commun, 11, 4318 (2020). https://doi.org/10.1038/s41467-020-17900-3
\item https://en.wikipedia.org/wiki/Kullback\%E2\%80\%93Leibler_divergence
}
}
\seealso{
\code{\link{runSGSA}} to calculate the activity score of gene sets, \code{\link{runLISA}} to explore the hotspot for
specified features in the spatial space.
}
\author{
Shuangbin Xu
}
