% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-pred.cell.signature.R
\name{pred.cell.signature}
\alias{pred.cell.signature}
\alias{pred.cell.signature,SingleCellExperiment-method}
\alias{pred.cell.signature,SingleCellExperiment}
\alias{pred.cell.signature,SVPExperiment-method}
\alias{pred.cell.signature,SVPExperiment}
\title{predict the cell signature according the gene sets or pathway activity score.}
\usage{
pred.cell.signature(
  data,
  assay.type = "affi.score",
  threshold = NULL,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  pred.col.name = "pred.cell.sign",
  ...
)

\S4method{pred.cell.signature}{SingleCellExperiment}(
  data,
  assay.type = "affi.score",
  threshold = NULL,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  pred.col.name = "pred.cell.sign",
  ...
)

\S4method{pred.cell.signature}{SVPExperiment}(
  data,
  assay.type = "affi.score",
  threshold = NULL,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  pred.col.name = "pred.cell.sign",
  ...
)
}
\arguments{
\item{data}{A \linkS4class{SVPExperiment}, which has run \code{runSGSA} or \code{detect.svp}, or
a \linkS4class{SingleCellExperiment} which was extracted from \linkS4class{SVPExperiment} using
\code{gsvaExp} function.}

\item{assay.type}{which expressed data to be pulled to run, default is \code{affi.score}.}

\item{threshold}{numeric when the gene set activity score of cell less than the \code{threshold}, the cell
signature will be consider as 'unassigned', default is NULL, meaning will be calculated internally.}

\item{gsvaexp}{which gene set variation experiment will be pulled to run, this only work when \code{data} is a
\linkS4class{SVPExperiment}, default is NULL.}

\item{gsvaexp.assay.type}{which assay data in the specified \code{gsvaexp} will be used to run, default is NULL.}

\item{pred.col.name}{character the column name in \code{colData} of the result, default is \code{pred.cell.sign}.}

\item{...}{dot parameters}
}
\value{
if input is a \linkS4class{SVPExperiment}, output will be also a \linkS4class{SVPExperiment}, and the result
was stored at the \code{pred.col.name} column of \code{colData} in the specified \code{gsvaexp}, which is a
\linkS4class{SingleCellExperiment}. If input is a \linkS4class{SingleCellExperiment} (which is extracted from
\linkS4class{SVPExperiment} using \code{gsvaExp()} function), output will be a \linkS4class{SingleCellExperiment},
the result can be extracted using \code{colData()} function with specified column in default is \code{pred.cell.sign}.
}
\description{
predict the cell signature according the gene sets or pathway activity score.
}
\examples{
data(hpda_spe_cell_dec)
hpda_spe_cell_dec <- hpda_spe_cell_dec |>
  pred.cell.signature(assay.type = 1)
hpda_spe_cell_dec$pred.cell.sign |> table()
#\donttest{
  library(ggsc)
  library(ggplot2)
  hpda_spe_cell_dec |> 
    sc_spatial(
      mapping = aes(x, y, colour = pred.cell.sign),
      geom = geom_bgpoint,
      pointsize = 2
    )
#}
}
\seealso{
to calculate the activity score of gene sets or pathway: \code{\link{runSGSA}},
to keep the max gene set or pathway activity score of cell: \code{\link{cluster.assign}}.
}
