% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STATegRa_fused.R
\name{createOmicsExpressionSet}
\alias{createOmicsExpressionSet}
\alias{createOmicsExpressionSet,matrix-method}
\title{createOmicsExpressionSet}
\usage{
createOmicsExpressionSet(Data, pData = NULL, pDataDescr = NULL,
  feaData = NULL, feaDataDescr = NULL)
}
\arguments{
\item{Data}{Omics data}

\item{pData}{Data associated with the samples/phenotype}

\item{pDataDescr}{Description of the phenotypic data}

\item{feaData}{Data associated with the variables/features annotation}

\item{feaDataDescr}{Description of the feature annotation}
}
\value{
ExpressionSet with the data provided
}
\description{
This function allow to the user to create a ExpressionSet object from a matrix representing an omics dataset. It allows to include the experimental design and annotation in the ExpressionSet object.
}
\details{
In Data matrix, samples has to be in columns and variables has to be in rows
}
\examples{
data(STATegRa_S3)
B1 <- createOmicsExpressionSet(Data=Block1.PCA,pData=ed.PCA,
                               pDataDescr=c("classname"))
B2 <- createOmicsExpressionSet(Data=Block2.PCA,pData=ed.PCA,
                               pDataDescr=c("classname"))
}
\author{
Patricia Sebastian-Leon
}
\keyword{datagen}
