% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotInteractions.R
\name{plotInteractions}
\alias{plotInteractions}
\alias{plotHeatmap}
\alias{plotNetwork}
\title{Plot group interactions}
\usage{
plotInteractions(
  x,
  which = c("heatmap", "network"),
  metric = c("prop", "jaccard"),
  min_prop = 0,
  ...
)
}
\arguments{
\item{x}{numeric matrix with rows = samples and columns = groups.
Must have at least one row and column, and at least two columns.}

\item{which}{character string specifying the type of
visualization: one of "heatmap" or "network".}

\item{metric}{character string specifying which metric to show:
one of "prop" or "jaccard".}

\item{min_prop}{scalar specifying the value above which
a group is considered to be contributing to a given sample.
An interaction between groups i and j is counted for sample s
only when both x[s, i] and x[s, j] fall above \code{min_prop}.}

\item{...}{additional graphical parameters passed
to \code{plot.igraph} when \code{which = "network"}
(see \code{?igraph.plotting}).}
}
\value{
base R plot
}
\description{
This function takes in a matrix with the predicted proportions
  for each spot and returns a heatmap \code{which = plotHeatmap} or a network
   graph \code{which = plotNetwork} to show which cells are interacting
   spatially.
}
\examples{
library(ggplot2)
mat <- replicate(8, rnorm(100, runif(1, -1, 1)))
# Basic example
plotInteractions(mat)

### heatmap ###
# This returns a ggplot object that can be modified as such
plotInteractions(mat, which = "heatmap") +
    scale_fill_gradient(low = "#f2e552", high = "#850000") +
    labs(title = "Interaction heatmap", fill = "proportion")
        
### Network ###
# specify node names
nms <- letters[seq_len(ncol(mat))]
plotInteractions(mat, which = "network", vertex.label = nms)

# or set column names instead
colnames(mat) <- nms
plotInteractions(mat, which = "network")

# pass additional graphical parameters for aesthetics
plotInteractions(mat,
    which = "network",
    edge.color = "cyan",
    vertex.color = "pink",
    vertex.label.font = 2,
    vertex.label.color = "maroon")
}
\author{
Marc Elosua Bayes & Helena L Crowell
}
