% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_splinter.R
\name{extractSpliceEvents}
\alias{extractSpliceEvents}
\title{extractSpliceEvents}
\usage{
extractSpliceEvents(
  data = NULL,
  filetype = "mats",
  splicetype = "SE",
  fdr = 1,
  inclusion = 1,
  start0 = TRUE
)
}
\arguments{
\item{data}{character. path to file}

\item{filetype}{character. type of splicing output. c('mats','custom'). see Details.}

\item{splicetype}{character. c('SE', 'RI', 'MXE', 'A5SS', 'A3SS')}

\item{fdr}{numeric. false discovery rate filter range [0,1]}

\item{inclusion}{numeric. splicing inclusion range, takes absolute value}

\item{start0}{boolean 0-base start}
}
\value{
list containing information on\cr
  (1) original file type\cr
  (2) splice event type\cr
  (3) data.frame with splicing regions
}
\description{
Extracts the location of target, upstream and downstream splice sites
Used for calculations and genome visualizations
}
\details{
filetype 'custom' should provide a 9-column tab-delimited text file
   with the following columns:
   ID (Ensembl gene id), Symbol (gene name), chr, strand,
   exonStart, exonEnd, exon2Start, exon2End, upstreamStart, upstreamEnd, downstreamStart, downstreamEnd
   eg. ENSG0000012345 chr1 + 3 4 5 6 1 2 7 8
}
\examples{
data_path<-system.file("extdata",package="SPLINTER")
splice_data<-extractSpliceEvents(data=paste(data_path,"/skipped_exons.txt",sep=""))
}
\seealso{
\url{http://rnaseq-mats.sourceforge.net/user_guide.htm} for MATS file definition
}
\author{
Diana Low
}
