% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_HALO_to_spe.R
\name{format_halo_to_spe}
\alias{format_halo_to_spe}
\title{Format a HALO image into a SpatialExperiment object}
\usage{
format_halo_to_spe(
  path = NULL,
  markers = NULL,
  locations = NULL,
  dye_columns_interest = NULL,
  intensity_columns_interest = NULL
)
}
\arguments{
\item{path}{String of the path location of HALO text file.}

\item{markers}{String Vector containing the markers used for staining.}

\item{locations}{(Optional) Vector containing the locations of markers used for
staining. Location can be either "Nucleus", "Cytoplasm" or "Membrane". This
is used to select the Intensity column and can be used instead of
`intensity_columns_interest`.}

\item{dye_columns_interest}{(Optional) Use if locations is not
specified. Vector of names of the columns with the marker status (i.e.
those indicating 1 or 0 for whether the cell is positive or negative for
the marker). Column names must match the order of the 'markers' parameter.}

\item{intensity_columns_interest}{(Optional) Use if locations is not
specified. Vector with the names of the columns with the level of each
marker. Column names must match the order of the 'markers' parameter.}
}
\value{
A SpatialExperiment object is returned
}
\description{
Reads in HALO data in the form of cell coordinates, cell
  phenotypes (if available), and marker intensities and transforms to a
  `SpatialExperiment` object. The assay stores the intensity level of every
  marker (rows) for every cell (columns). Cell x and y coordinates are stored
  under `spatialCoords()`. Cell phenotype and other cell properties are
  stored under colData. The cell properties to be included are Cell.Area,
  Nucleus.Area and Cytoplasm.Area. Note that if the data does not include
  these parameters, we recommend adding it to the output from HALO with NAs
  in columns.
}
\examples{
raw_halo_data <- system.file("extdata", "tiny_halo.csv.gz", package="SPIAT")
markers <- c("DAPI", "CD3", "PDL-1", "CD4", "CD8", "AMACR")
intensity_columns_interest <- c("Dye 1 Nucleus Intensity",
"Dye 2 Cytoplasm Intensity","Dye 3 Membrane Intensity",
"Dye 4 Cytoplasm Intensity", "Dye 5 Cytoplasm Intensity",
"Dye 6 Cytoplasm Intensity")
dye_columns_interest <-c("Dye 1 Positive Nucleus","Dye 2 Positive Cytoplasm",
"Dye 3 Positive Membrane", "Dye 4 Positive Cytoplasm",
"Dye 5 Positive Cytoplasm", "Dye 6 Positive Cytoplasm")
formatted_HALO <- format_halo_to_spe(path=raw_halo_data,markers=markers, 
intensity_columns_interest=intensity_columns_interest,
dye_columns_interest=dye_columns_interest)
}
