% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_entropy.R
\name{calculate_entropy}
\alias{calculate_entropy}
\title{calculate_entropy}
\usage{
calculate_entropy(
  spe_object,
  cell_types_of_interest,
  feature_colname = "Phenotype",
  radius = NULL
)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{cell_types_of_interest}{String Vector. Cell types of interest. If arg
`radius` is not NULL, the first cell type is considered as reference cell
type. Circles of the specified radius will be drawn around the reference
cells and the entropy of cell types will be calculated for each of the
reference cells.}

\item{feature_colname}{String specifying the column the cell types are from.}

\item{radius}{(OPTIONAL) Numeric. The maximum radius around a reference cell
for another cell to be considered an interaction.}
}
\value{
A dataframe or a number depending on the argument radius
}
\description{
If arg `radius` is not specified, the function returns the
  entropy of the cell types of interest for the whole image. If arg `radius`
  is specified, the function returns a data frame where each row is a
  reference cell and the columns stores the entropy of the cell types of
  interest in each circle of the reference cells.
}
\examples{
calculate_entropy(SPIAT::defined_image, 
cell_types_of_interest = c("Immune1","Immune2"),
feature_colname = "Cell.Type")
}
