% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_distance_heatmap.R
\name{plot_distance_heatmap}
\alias{plot_distance_heatmap}
\title{plot_distance_heatmap}
\usage{
plot_distance_heatmap(phenotype_distances_result, metric = "mean")
}
\arguments{
\item{phenotype_distances_result}{Dataframe output from
`calculate_summary_distances_between_celltypes` or
`calculate_minimum_distances_between_celltypes`.}

\item{metric}{Metric to be plotted. One of "mean", "std.dev", "median", "min"
or "max".}
}
\value{
A plot is returned
}
\description{
Takes the output of cell_distances and plot the distances as a
  heatmap.
}
\examples{
dists <- calculate_pairwise_distances_between_celltypes(SPIAT::defined_image, 
cell_types_of_interest = c("Tumour","Immune1"), feature_colname = "Cell.Type")
summary_distances <- calculate_summary_distances_between_celltypes(dists)
plot_distance_heatmap(summary_distances)
}
